package com.artfess.yhxt.yjjy.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2022-05-30
 */
@ApiModel(value="SiteInspectionYjjy对象", description="应急救援-日常巡检")
@TableName("biz_site_inspection_yjjy")
@Data
public class SiteInspectionYjjy extends BaseModel<SiteInspectionYjjy> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "路段编号")
    @TableField("s_road_")
    private String sRoad;

    @ApiModelProperty(value = "巡检编号")
    @TableField("s_no_")
    private String sNo;

    @ApiModelProperty(value = "天气")
    @TableField("s_weather_")
    private String sWeather;

    @ApiModelProperty(value = "开始里程")
    @TableField("n_begin_long_")
    private String nBeginLong;

    @ApiModelProperty(value = "结束里程")
    @TableField("n_end_long_")
    private String nEndLong;

    @ApiModelProperty(value = "巡查里程")
    @TableField("n_run_long_")
    private String nRunLong;

    @ApiModelProperty(value = "开始时间")
    @TableField("d_begin_time_")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime dBeginTime;

    @ApiModelProperty(value = "结束时间")
    @TableField("d_end_time_")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime dEndTime;

    @ApiModelProperty(value = "巡检用时")
    @TableField("n_time_")
    private String nTime;

    @ApiModelProperty(value = "巡检状态")
    @TableField("s_status_")
    private String sStatus;

    @TableField("s_type_")
    private String sType;

    @ApiModelProperty(value = "白班 夜班")
    @TableField("s_class_")
    private String sClass;

    @ApiModelProperty(value = "巡检")
    @TableField("s_kind_")
    private String sKind;

    @ApiModelProperty(value = "巡检内容")
    @TableField("s_task_value_")
    private String sTaskValue;

    @ApiModelProperty(value = "巡检人多个用逗号分割")
    @TableField("s_do_person_name_")
    private String sDoPersonName;


}
