package com.artfess.yhxt.thirdparty.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.query.*;
import com.artfess.base.util.time.DateUtil;
import com.artfess.uc.api.model.Group;
import com.artfess.yhxt.thirdparty.model.BizTpDevice;
import com.artfess.yhxt.thirdparty.vo.TpDeviceTypeCountVo;
import com.artfess.yhxt.thirdparty.vo.WarningEventsVountVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.thirdparty.model.BizTpWarningEvents;
import com.artfess.yhxt.thirdparty.manager.BizTpWarningEventsManager;

import java.util.List;

/**
 * 第三方传输预警事件 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-06-15
 */
@RestController
@RequestMapping("/bizTpWarningEvents/v1/")
@Api(tags = "第三方传输预警事件信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizTpWarningEventsController extends BaseController<BizTpWarningEventsManager, BizTpWarningEvents> {


    @RequestMapping(value = "warningCountTotal", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value ="预警信息统计", httpMethod = "POST", notes = "预警信息统计")
    public WarningEventsVountVo warningCountTotal(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizTpWarningEvents> queryFilter) {
        List<QueryField> querys = queryFilter.getQuerys();
        int j=0;
        int k=0;
        for (QueryField query : querys) {
            if(query.getProperty().equals("modelDateGreat")){
                query.setProperty("EVENTS_DATE_");
                query.setOperation(QueryOP.GREAT_EQUAL);
                j++;
            }
            if(query.getProperty().equals("modelDateLess")){
                query.setProperty("EVENTS_DATE_");
                query.setOperation(QueryOP.LESS_EQUAL);
                query.setValue(  DateUtil.getNextDay((String) query.getValue())   );
                k++;
            }
        }


        if(j == 0 || k ==0){
            QueryField queryField1 = new QueryField();

            queryField1.setProperty("EVENTS_DATE_");
            queryField1.setOperation(QueryOP.GREAT_EQUAL);
            queryField1.setGroup("main");
            queryField1.setRelation(FieldRelation.AND);
            queryField1.setValue(DateUtil.getStartDayByMonth());

            querys.add(queryField1);



            QueryField queryField2 = new QueryField();

            queryField2.setProperty("EVENTS_DATE_");
            queryField2.setOperation(QueryOP.LESS_EQUAL);
            queryField2.setGroup("main");
            queryField2.setRelation(FieldRelation.AND);
            queryField2.setValue(DateUtil.getLastDayByMonth());
            querys.add(queryField2);

        }


        return baseService.warningCountTotal(queryFilter);
    }


    @RequestMapping(value = "pageList", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value ="未处置预警事件", httpMethod = "POST", notes = "未处置预警事件")
    public PageList<BizTpWarningEvents> pageList(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizTpWarningEvents> queryFilter) {

        List<QueryField> querys = queryFilter.getQuerys();

        int i=0;
        int j=0;
        int k=0;

        for (QueryField query : querys) {
            if(query.getProperty().equals("modelDateGreat")){
                query.setProperty("EVENTS_DATE_");
                query.setOperation(QueryOP.GREAT_EQUAL);
                j++;
            }
            if(query.getProperty().equals("modelDateLess")){
                query.setProperty("EVENTS_DATE_");
                query.setOperation(QueryOP.LESS_EQUAL);
                query.setValue(  DateUtil.getNextDay((String) query.getValue())   );
                k++;
            }
            if(query.getProperty().equals("eventsState")){
                i++;

            }
        }

        if(i == 0){
            QueryField queryField = new QueryField();

            queryField.setProperty("eventsState");
            queryField.setOperation(QueryOP.EQUAL);
            queryField.setGroup("main");
            queryField.setRelation(FieldRelation.AND);
            queryField.setValue(0);
            querys.add(queryField);

        }


        if(j == 0 || k ==0){
            QueryField queryField1 = new QueryField();

            queryField1.setProperty("EVENTS_DATE_");
            queryField1.setOperation(QueryOP.GREAT_EQUAL);
            queryField1.setGroup("main");
            queryField1.setRelation(FieldRelation.AND);
            queryField1.setValue(DateUtil.getStartDayByMonth());

            querys.add(queryField1);



            QueryField queryField2 = new QueryField();

            queryField2.setProperty("EVENTS_DATE_");
            queryField2.setOperation(QueryOP.LESS_EQUAL);
            queryField2.setGroup("main");
            queryField2.setRelation(FieldRelation.AND);
            queryField2.setValue(DateUtil.getLastDayByMonth());
            querys.add(queryField2);

        }



        List<FieldSort> sorter = queryFilter.getSorter();
        if(null == sorter || sorter.isEmpty()){
            sorter.add(new FieldSort("EVENTS_DATE_", Direction.DESC));
            queryFilter.setSorter(sorter);
        }

        return baseService.pageList(queryFilter);
    }

}
