package com.artfess.yhxt.task.model;

import java.math.BigDecimal;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableField;

import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 主要是从各个业务过程中向里面插入待处理的任务数据，然后提供门户进行统一查询跳转并处理
 *
 * @author baseli
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-09-16
 */
@ApiModel(value = "BizTaskWaitHandle对象", description = "主要是从各个业务过程中向里面插入待处理的任务数据，然后提供门户进行统一查询跳转并处理")
@TableName("BIZ_TASK_WAIT_HANDLE")
public class TaskWaitHandle extends AutoFillModel<TaskWaitHandle> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "业务数据类型，1：巡检任务，2：养护任务")
    @TableField("BIZ_TYPE")
    private String bizType;

    @ApiModelProperty(value = "业务数据_ID")
    @TableField("BIZ_ID")
    private String bizId;

    @ApiModelProperty(value = "工作项_来源（1：流程任务、2 ：功能审批、3：消息通知）")
    @TableField("ITEM_SOURCE")
    private Integer itemSource;

    @ApiModelProperty(value = "工作项_类型（1：待办事项、2： 待阅事项）")
    @TableField("ITEM_TYPE")
    private Integer itemType;

    @ApiModelProperty(value = "工作项_ID，（待办、待阅） 在业务系统中的唯一标识")
    @TableField("ITEM_ID")
    private String itemId;

    @ApiModelProperty(value = "工作项标题【需要组合任务生成标题名称】")
    @TableField("ITEM_TITLE")
    private String itemTitle;

    @ApiModelProperty(value = "发送单位_ID")
    @TableField("SEND_DEPT_ID")
    private String sendDeptId;

    @ApiModelProperty(value = "发送单位_NAME")
    @TableField("SEND_DEPT_NAME")
    private String sendDeptName;

    @ApiModelProperty(value = "发送者_ID")
    @TableField("SEND_USER_ID")
    private String sendUserId;

    @ApiModelProperty(value = "发送者_账号")
    @TableField("SEND_LOGIN_NAME")
    private String sendLoginName;

    @ApiModelProperty(value = "发送者_NAME")
    @TableField("SEND_USER_NAME")
    private String sendUserName;

    @ApiModelProperty(value = "发送时间")
    @TableField("SEND_DATE")
    private LocalDateTime sendDate;

    @ApiModelProperty(value = "计划规定的完成时间")
    @TableField("PLAN_COMPLETE_DATE")
    private LocalDateTime planCompleteDate;

    @ApiModelProperty(value = "访问的应用链接，公告在业务系统中的访问地址。访问之后改变状态。")
    @TableField("URL")
    private String url;

    @ApiModelProperty(value = "优先级（0 一般；1紧急；2 特急；3其他）")
    @TableField("PRIORITY")
    private Integer priority;

    @ApiModelProperty(value = "执行模式（1：并行操作  2：抢占操作）")
    @TableField("MODE_TYPE")
    private Integer modeType;

    @ApiModelProperty(value = "接收者部门_ID")
    @TableField("RECEIVE_DEPT_ID")
    private String receiveDeptId;

    @ApiModelProperty(value = "接收者部门_名称")
    @TableField("RECEIVE_DEPT_NAME")
    private String receiveDeptName;

    @ApiModelProperty(value = "接收者_ID")
    @TableField("RECEIVE_USER_ID")
    private String receiveUserId;

    @ApiModelProperty(value = "接收人_账号")
    @TableField("RECEIVE_LOGIN_NAME")
    private String receiveLoginName;

    @ApiModelProperty(value = "接收人姓名")
    @TableField("RECEIVE_USER_NAME")
    private String receiveUserName;

    @ApiModelProperty(value = "任务流程的定义ID  一个定义下可有多个实例  如果说流程定义比喻成类  那流程实例则为该类的对象   非必填项")
    @TableField("WORKFLOW_ID")
    private String workflowId;

    @ApiModelProperty(value = "任务流程定义的名称 非必填项")
    @TableField("WORKFLOW_NAME")
    private String workflowName;

    @ApiModelProperty(value = "在一个任务定义下可以开启多个任务实例  非必填项")
    @TableField("WORKFLOW_INSTANCE")
    private String workflowInstance;

    @ApiModelProperty(value = "任务流程实例名称 非必填项")
    @TableField("WORKFLOW_INSTANCE_NAME")
    private String workflowInstanceName;

    @ApiModelProperty(value = "一个流程对应多个活动环节  非必填项")
    @TableField("ACTIVITIES_ID")
    private String activitiesId;

    @ApiModelProperty(value = "非必填项")
    @TableField("ACTIVITIES_NAME")
    private String activitiesName;

    @ApiModelProperty(value = "活动定义实例化 活动定义为相当于活动类型  活动实例相当于活动类型下的具体对象")
    @TableField("ACTIVITIES_INSTANCE")
    private String activitiesInstance;

    @ApiModelProperty(value = "非必填项")
    @TableField("ACTIVITIES_INSTANCE_NAME")
    private String activitiesInstanceName;

    @ApiModelProperty(value = "建议")
    @TableField("ADVICE")
    private String advice;


    @ApiModelProperty(value = "版本号")
    @TableField("VERSION")
    private BigDecimal version;



    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Integer getItemSource() {
        return itemSource;
    }

    public void setItemSource(Integer itemSource) {
        this.itemSource = itemSource;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public String getItemId() {
        return itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getItemTitle() {
        return itemTitle;
    }

    public void setItemTitle(String itemTitle) {
        this.itemTitle = itemTitle;
    }

    public String getSendDeptId() {
        return sendDeptId;
    }

    public void setSendDeptId(String sendDeptId) {
        this.sendDeptId = sendDeptId;
    }

    public String getSendDeptName() {
        return sendDeptName;
    }

    public void setSendDeptName(String sendDeptName) {
        this.sendDeptName = sendDeptName;
    }

    public String getSendUserId() {
        return sendUserId;
    }

    public void setSendUserId(String sendUserId) {
        this.sendUserId = sendUserId;
    }

    public String getSendLoginName() {
        return sendLoginName;
    }

    public void setSendLoginName(String sendLoginName) {
        this.sendLoginName = sendLoginName;
    }

    public String getSendUserName() {
        return sendUserName;
    }

    public void setSendUserName(String sendUserName) {
        this.sendUserName = sendUserName;
    }

    public LocalDateTime getSendDate() {
        return sendDate;
    }

    public void setSendDate(LocalDateTime sendDate) {
        this.sendDate = sendDate;
    }

    public LocalDateTime getPlanCompleteDate() {
        return planCompleteDate;
    }

    public void setPlanCompleteDate(LocalDateTime planCompleteDate) {
        this.planCompleteDate = planCompleteDate;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getModeType() {
        return modeType;
    }

    public void setModeType(Integer modeType) {
        this.modeType = modeType;
    }

    public String getReceiveDeptId() {
        return receiveDeptId;
    }

    public void setReceiveDeptId(String receiveDeptId) {
        this.receiveDeptId = receiveDeptId;
    }

    public String getReceiveDeptName() {
        return receiveDeptName;
    }

    public void setReceiveDeptName(String receiveDeptName) {
        this.receiveDeptName = receiveDeptName;
    }

    public String getReceiveUserId() {
        return receiveUserId;
    }

    public void setReceiveUserId(String receiveUserId) {
        this.receiveUserId = receiveUserId;
    }

    public String getReceiveLoginName() {
        return receiveLoginName;
    }

    public void setReceiveLoginName(String receiveLoginName) {
        this.receiveLoginName = receiveLoginName;
    }

    public String getReceiveUserName() {
        return receiveUserName;
    }

    public void setReceiveUserName(String receiveUserName) {
        this.receiveUserName = receiveUserName;
    }

    public String getWorkflowId() {
        return workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public String getWorkflowName() {
        return workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public String getWorkflowInstance() {
        return workflowInstance;
    }

    public void setWorkflowInstance(String workflowInstance) {
        this.workflowInstance = workflowInstance;
    }

    public String getWorkflowInstanceName() {
        return workflowInstanceName;
    }

    public void setWorkflowInstanceName(String workflowInstanceName) {
        this.workflowInstanceName = workflowInstanceName;
    }

    public String getActivitiesId() {
        return activitiesId;
    }

    public void setActivitiesId(String activitiesId) {
        this.activitiesId = activitiesId;
    }

    public String getActivitiesName() {
        return activitiesName;
    }

    public void setActivitiesName(String activitiesName) {
        this.activitiesName = activitiesName;
    }

    public String getActivitiesInstance() {
        return activitiesInstance;
    }

    public void setActivitiesInstance(String activitiesInstance) {
        this.activitiesInstance = activitiesInstance;
    }

    public String getActivitiesInstanceName() {
        return activitiesInstanceName;
    }

    public void setActivitiesInstanceName(String activitiesInstanceName) {
        this.activitiesInstanceName = activitiesInstanceName;
    }

    public String getAdvice() {
        return advice;
    }

    public void setAdvice(String advice) {
        this.advice = advice;
    }

    public BigDecimal getVersion() {
        return version;
    }

    public void setVersion(BigDecimal version) {
        this.version = version;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    public static TaskAlreadyHandleHistory getTaskAlreadyHandleHistory(TaskWaitHandle taskWaitHandle) {
        TaskAlreadyHandleHistory taskAlreadyHandleHistory = new TaskAlreadyHandleHistory();
        taskAlreadyHandleHistory.setBizId(taskWaitHandle.getBizId());
        taskAlreadyHandleHistory.setBizType(taskWaitHandle.getBizType());
        taskAlreadyHandleHistory.setItemSource(taskWaitHandle.getItemSource());
        taskAlreadyHandleHistory.setItemType(taskWaitHandle.getItemType());
        taskAlreadyHandleHistory.setItemId(taskWaitHandle.getItemId());
        taskAlreadyHandleHistory.setItemTitle(taskWaitHandle.getItemTitle());
        taskAlreadyHandleHistory.setSendDeptId(taskWaitHandle.getSendDeptId());
        taskAlreadyHandleHistory.setSendDeptName(taskWaitHandle.getSendDeptName());
        taskAlreadyHandleHistory.setSendUserId(taskWaitHandle.getSendUserId());
        taskAlreadyHandleHistory.setSendUserName(taskWaitHandle.getSendUserName());
        taskAlreadyHandleHistory.setSendDate(taskWaitHandle.getSendDate());
        taskAlreadyHandleHistory.setPlanCompleteDate(taskWaitHandle.getPlanCompleteDate());
        taskAlreadyHandleHistory.setUrl(taskWaitHandle.getUrl());
        taskAlreadyHandleHistory.setPriority(taskWaitHandle.getPriority());
        taskAlreadyHandleHistory.setModeType(taskWaitHandle.getModeType());
        taskAlreadyHandleHistory.setReceiveDeptId(taskWaitHandle.getReceiveDeptId());
        taskAlreadyHandleHistory.setReceiveDeptName(taskWaitHandle.getReceiveDeptName());
        taskAlreadyHandleHistory.setReceiveUserId(taskWaitHandle.getReceiveUserId());
        taskAlreadyHandleHistory.setReceiveLoginName(taskWaitHandle.getReceiveLoginName());
        taskAlreadyHandleHistory.setReceiveUserName(taskWaitHandle.getReceiveUserName());
        taskAlreadyHandleHistory.setWorkflowId(taskWaitHandle.getWorkflowId());
        taskAlreadyHandleHistory.setWorkflowInstance(taskWaitHandle.getWorkflowInstance());
        taskAlreadyHandleHistory.setWorkflowInstanceName(taskWaitHandle.getWorkflowInstanceName());
        taskAlreadyHandleHistory.setWorkflowName(taskWaitHandle.getWorkflowName());
        taskAlreadyHandleHistory.setActivitiesId(taskWaitHandle.getActivitiesId());
        taskAlreadyHandleHistory.setActivitiesName(taskWaitHandle.getActivitiesName());
        taskAlreadyHandleHistory.setActivitiesInstance(taskWaitHandle.getActivitiesInstance());
        taskAlreadyHandleHistory.setActivitiesInstanceName(taskWaitHandle.getActivitiesInstanceName());

        return taskAlreadyHandleHistory;
    }

    @Override
    public String toString() {
        return "BizTaskWaitHandle{" +
                "id=" + id +
                ", bizType=" + bizType +
                ", bizId=" + bizId +
                ", itemSource=" + itemSource +
                ", itemType=" + itemType +
                ", itemId=" + itemId +
                ", itemTitle=" + itemTitle +
                ", sendDeptId=" + sendDeptId +
                ", sendDeptName=" + sendDeptName +
                ", sendUserId=" + sendUserId +
                ", sendLoginName=" + sendLoginName +
                ", sendUserName=" + sendUserName +
                ", sendDate=" + sendDate +
                ", planCompleteDate=" + planCompleteDate +
                ", url=" + url +
                ", priority=" + priority +
                ", modeType=" + modeType +
                ", receiveDeptId=" + receiveDeptId +
                ", receiveDeptName=" + receiveDeptName +
                ", receiveUserId=" + receiveUserId +
                ", receiveLoginName=" + receiveLoginName +
                ", receiveUserName=" + receiveUserName +
                ", workflowId=" + workflowId +
                ", workflowName=" + workflowName +
                ", workflowInstance=" + workflowInstance +
                ", workflowInstanceName=" + workflowInstanceName +
                ", activitiesId=" + activitiesId +
                ", activitiesName=" + activitiesName +
                ", activitiesInstance=" + activitiesInstance +
                ", activitiesInstanceName=" + activitiesInstanceName +
                ", version=" + version +
                "}";
    }
}
