package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.time.LocalDateTime;
import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 项目招投标信息表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-17
 */
@ApiModel(value="BizProjectBidding对象", description="项目招投标信息表")
@TableName("biz_project_bidding")
@Data
public class BizProjectBidding extends BizModel<BizProjectBidding> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "公司ID选择路段进行带入")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "所在路段id(关联路段表ID)")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "所在路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "项目id")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "项目name")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "子项目id")
    @TableField("SUBPROJECT_ID_")
    private String subprojectId;

    @ApiModelProperty(value = "子项目name")
    @TableField("SUBPROJECT_NAME_")
    private String subprojectName;

    @ApiModelProperty(value = "系统功能")
    @TableField("SYSTEM_FUNCTION_")
    private String systemFunction;

    @ApiModelProperty(value = "资料类型，数据字典，招标文件、投标文件、其他文件")
    @TableField("DATA_TYPE_")
    private Integer dataType;

    @ApiModelProperty(value = "资料提供方，数据字典，1：业主方，2：监理方，3：施工方")
    @TableField("UPLOAD_ROLE")
    private Integer uploadRole;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "创建人组织名称")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="CREATE_ORG_NAME_", fill= FieldFill.INSERT, select=false)
    private String createOrgName;

    @ApiModelProperty(value = "创建人单位ID")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="CREATE_COMPANY_ID_", fill= FieldFill.INSERT, select=false)
    private String createCompanyId;

    @ApiModelProperty(value = "创建人单位名称")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="CREATE_COMPANY_NAME_", fill= FieldFill.INSERT, select=false)
    private String createCompanyName;

    @ApiModelProperty(value = "创建人姓名")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="CREATE_NAME_", fill= FieldFill.INSERT, select=false)
    private String createName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getSubprojectId() {
        return subprojectId;
    }

    public void setSubprojectId(String subprojectId) {
        this.subprojectId = subprojectId;
    }
    public String getSubprojectName() {
        return subprojectName;
    }

    public void setSubprojectName(String subprojectName) {
        this.subprojectName = subprojectName;
    }
    public String getSystemFunction() {
        return systemFunction;
    }

    public void setSystemFunction(String systemFunction) {
        this.systemFunction = systemFunction;
    }
    public Integer getDataType() {
        return dataType;
    }

    public void setDataType(Integer dataType) {
        this.dataType = dataType;
    }
    public Integer getUploadRole() {
        return uploadRole;
    }

    public void setUploadRole(Integer uploadRole) {
        this.uploadRole = uploadRole;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    public String getCreateOrgName() {
        return createOrgName;
    }

    @Override
    public void setCreateOrgName(String createOrgName) {
        this.createOrgName = createOrgName;
    }

    @Override
    public String getCreateCompanyId() {
        return createCompanyId;
    }

    @Override
    public void setCreateCompanyId(String createCompanyId) {
        this.createCompanyId = createCompanyId;
    }

    @Override
    public String getCreateCompanyName() {
        return createCompanyName;
    }

    @Override
    public void setCreateCompanyName(String createCompanyName) {
        this.createCompanyName = createCompanyName;
    }

    @Override
    public String getCreateName() {
        return createName;
    }

    @Override
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizProjectBidding{" +
            "id=" + id +
            ", projectId=" + projectId +
            ", projectName=" + projectName +
            ", subprojectId=" + subprojectId +
            ", subprojectName=" + subprojectName +
            ", systemFunction=" + systemFunction +
            ", dataType=" + dataType +
            ", uploadRole=" + uploadRole +
            ", remarks=" + remarks +
        "}";
    }
}
