package com.artfess.yhxt.specialproject.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialproject.vo.ProjectContractPaymentVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialproject.model.ProjectContractPayment;
import com.artfess.yhxt.specialproject.manager.ProjectContractPaymentManager;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

/**
 * 项目合同支付表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-19
 */
@RestController
@RequestMapping("/projectContractPayment/v1/")
@Api(tags = "项目合同支付明细接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ProjectContractPaymentController extends BaseController<ProjectContractPaymentManager, ProjectContractPayment> {


    @Resource
    private BaseContext baseContext;

    @RequestMapping(value = "getJson", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "分页查询项目合同支付信息", httpMethod = "POST")
    public PageList<ProjectContractPayment> getJson(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<ProjectContractPayment> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){

        }
        PageList<ProjectContractPayment> pageList = baseService.queryProjectContractPayment(queryFilter);
        return pageList;
    }

    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改项目项目合同支付", httpMethod = "POST")
    public CommonResult<String> save(@ApiParam(name = "projectContractPayment", value = "项目合同支付明细对象") @RequestBody List<ProjectContractPayment> paymentList
            , @ApiParam(name = "contractId", value = "合同ID", required = true)
                                         @RequestParam(value = "contractId", required = true)String contractId) throws Exception {
        String msg = "添加成功";
        if (paymentList.size()>0){
            baseService.createProjectContractPayment(paymentList,contractId);
        }
 
        return new CommonResult<String>(msg);
    }


    @RequestMapping(value = "/deleteProjectContractPayment", method = RequestMethod.DELETE, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除项目合同支付明细", httpMethod = "DELETE", notes = "逻辑删除项目合同支付明细")
    public CommonResult<String> deleteProjectContractPayment(@ApiParam(name = "ids", value = "ID集合以，隔开", required = true)
                                                          @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<ProjectContractPayment> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("ID_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }



    @RequestMapping(value = "/importDatePay", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量导入项目合同支付明细", httpMethod = "POST",notes = "批量导入项目合同支付明细")
    public CommonResult<String> importDatePay(@ApiParam(name = "file", value = "项目交工支付明细文件")@RequestBody MultipartFile file,
                                           @ApiParam(name = "contractId", value = "项目ID")  String contractId
                                           ) throws Exception {

        this.baseService.importDatePay(file,contractId);
        return new CommonResult<String>("导入成功");
    }
    @GetMapping(value = "get/{contractId}")
    @ApiOperation(value = "根据ID查询项目合同支付明细",httpMethod = "GET",notes = "根据ID查询项目合同支付明细")
    public ProjectContractPaymentVo get(@ApiParam(name = "contractId", value = "项目合同主键id", required = true)  @PathVariable String contractId) throws Exception{
        return baseService.getVo(contractId);
    }

    @RequestMapping(value = "/downTemplate", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量导入项目合同支付明细模板下载", httpMethod = "POST",notes = "批量导入项目合同支付明细模板下载")
    public void downTemplate(HttpServletResponse response) throws Exception {
        this.baseService.downTemplate(response);
    }


    @RequestMapping(value = "/exportDatePay", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "导出项目合同支付明细", httpMethod = "POST",notes = "导出项目合同支付明细")
    public void exportDatePay(@ApiParam(name = "ids", value = "ID集合以，隔开")
                                                  @RequestParam(value = "ids", required = true)String ids,HttpServletResponse response) throws Exception {

        this.baseService.exportDatePay(ids,response);
        //return new CommonResult<String>("导出成功");
    }
}
