package com.artfess.yhxt.specialcheck.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.specialcheck.dao.BizMqiCheckDataDao;
import com.artfess.yhxt.specialcheck.manager.BizMqiCheckDataManager;
import com.artfess.yhxt.specialcheck.manager.BizMqiCheckDetailManager;
import com.artfess.yhxt.specialcheck.model.BizMqiCheckData;
import com.artfess.yhxt.specialcheck.model.BizMqiCheckDetail;
import com.artfess.yhxt.specialcheck.vo.BizMqiCheckDataVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;

/**
 * MQI检查数据表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-10
 */
@Service
public class BizMqiCheckDataManagerImpl extends BaseManagerImpl<BizMqiCheckDataDao, BizMqiCheckData> implements BizMqiCheckDataManager {
    @Autowired
    private BizMqiCheckDetailManager bizMqiCheckDetailManager;
    @Autowired
    private AccessoryManager accessoryManager;

    @Override
    public PageList<BizMqiCheckData> queryBizMqiCheckData(QueryFilter<BizMqiCheckData> queryFilter) {
        IPage<BizMqiCheckData> result = baseMapper.queryBizMqiCheckData(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizMqiCheckDataVo getBizBridgeSpecialById(String id) {
        BizMqiCheckData bizMqiCheckData = baseMapper.selectById(id);
        BizMqiCheckDataVo bizMqiCheckDataVo = new BizMqiCheckDataVo();
        bizMqiCheckDataVo.setBizMqiCheckData(bizMqiCheckData);
        if(null != bizMqiCheckData && StringUtils.isNotBlank( bizMqiCheckData.getId())){
            bizMqiCheckDataVo.setDetailList(bizMqiCheckDetailManager.selectListByMqiDataId(id));
        }
        return bizMqiCheckDataVo;
    }

    @Override
    public void saveBizMqiCheckDataVo(BizMqiCheckDataVo vo) {
        BizMqiCheckData bizMqiCheckData = vo.getBizMqiCheckData();
        if(BeanUtils.isNotEmpty(bizMqiCheckData)){
            if (StringUtils.isEmpty(bizMqiCheckData.getId())) {
                bizMqiCheckData.setIsDele("0");
                this.save(bizMqiCheckData);
            } else {
                this.update(bizMqiCheckData);
            }
            if (vo.getDetailList() != null && vo.getDetailList().size() > 0) {
                vo.getDetailList().forEach(s -> {
                    s.setMqiDataId(bizMqiCheckData.getId());
                    if (StringUtils.isEmpty(s.getId())) {
                        this.bizMqiCheckDetailManager.save(s);
                    }else {
                        bizMqiCheckDetailManager.update(s);
                    }
                });
            }
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveVo(BizMqiCheckDataVo vo) {
        BizMqiCheckData bizMqiCheckData = vo.getBizMqiCheckData();
        List<Accessory> accessoryList = vo.getAccessoryList();
        if(BeanUtils.isNotEmpty(bizMqiCheckData)){
            if (StringUtils.isEmpty(bizMqiCheckData.getId())) {
                bizMqiCheckData.setIsDele("0");
                this.save(bizMqiCheckData);

                if (accessoryList!=null &&accessoryList.size()>0) {
                    String id = bizMqiCheckData.getId();
                    //删除原来的附件信息
                    this.accessoryManager.delAccessoryBySourceId(id);
                    //获取附件信息
                    accessoryList.forEach(s -> s.setSourceId(id));
                    this.accessoryManager.saveOrUpdateBatch(accessoryList);
                }
            } else {
                if (accessoryList!=null && accessoryList.size()>0) {
                    String id = bizMqiCheckData.getId();
                    //删除原来的附件信息
                    this.accessoryManager.delAccessoryBySourceId(id);
                    //获取附件信息
                    accessoryList.forEach(s -> s.setSourceId(id));
                    this.accessoryManager.saveOrUpdateBatch(accessoryList);
                }
                this.update(bizMqiCheckData);
            }
            List<BizMqiCheckDetail> detailList = vo.getDetailList();

            BigDecimal mqiAverage = new BigDecimal(0);

            if (null != vo.getDetailList()  && vo.getDetailList().size() > 0) {
                for (BizMqiCheckDetail bizMqiCheckDetail : detailList) {
                    bizMqiCheckDetail.setMqiDataId(bizMqiCheckData.getId());
                    Float mqiAvg = bizMqiCheckDetail.getMqiAvg();
                    if(null != mqiAvg){
                        BigDecimal a = new BigDecimal(String.valueOf(mqiAvg));
                        mqiAverage= mqiAverage.add(a);
                    }
                }
                bizMqiCheckDetailManager.saveOrUpdateBatch(detailList);
                if(null != mqiAverage && mqiAverage.compareTo(BigDecimal.ZERO) !=0){
                    mqiAverage= mqiAverage.divide(new BigDecimal(vo.getDetailList().size()) ,4,BigDecimal.ROUND_HALF_UP);
                }
            }



            bizMqiCheckData.setMqiAverage(mqiAverage);
            this.update(bizMqiCheckData);
        }


    }

    @Override
    public BizMqiCheckDataVo getVo(String id) {
        BizMqiCheckData bizMqiCheckData = baseMapper.selectById(id);
        BizMqiCheckDataVo bizMqiCheckDataVo = new BizMqiCheckDataVo();
        bizMqiCheckDataVo.setBizMqiCheckData(bizMqiCheckData);
        if(null != bizMqiCheckData && StringUtils.isNotBlank( bizMqiCheckData.getId())){
            bizMqiCheckDataVo.setDetailList(bizMqiCheckDetailManager.selectListByMqiDataId(id));
        }
        List<Accessory> accessoryList = accessoryManager.getAccessoryBySourceId(id);
        if (accessoryList!=null && accessoryList.size()>0) {
            bizMqiCheckDataVo.setAccessoryList(accessoryList);
        }

        return bizMqiCheckDataVo;
    }

}
