package com.artfess.yhxt.contract.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.contract.model.BillOfQuantities;
import com.artfess.yhxt.contract.manager.BillOfQuantitiesManager;

import java.util.Arrays;
import java.util.List;

/**
 * 工程量清单表 前端控制器
 *
 * @author xzh
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-08-18
 */
@RestController
@RequestMapping("/billOfQuantities/v1/")
@Api(tags = "工程量清单接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BillOfQuantitiesController extends BaseController<BillOfQuantitiesManager, BillOfQuantities> {
    @RequestMapping(value = "getJson", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "分页查询工程量清单", httpMethod = "POST")
    public PageList<BillOfQuantities> getJson(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BillOfQuantities> queryFilter) {
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        return baseService.queryBillOfQuantities(queryFilter);
    }

    @RequestMapping(value = "/saveBridge", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改工程量清单信息", httpMethod = "POST")
    public CommonResult<String> saveBridge(@ApiParam(name = "list", value = "工程量清单 isDele保存 '0'") @RequestBody List<BillOfQuantities> list) throws Exception {
        String msg = "添加成功";
        if (list.size() > 0) {
            if (StringUtils.isEmpty(list.get(0).getId())) {
                baseService.saveOrUpdateBatch(list);
            } else {
                //baseService.saveOrUpdateBatch(list);
                baseService.updateBatchById(list);
                msg = "修改成功";
            }
        }
        return new CommonResult<String>(msg);
    }



    @GetMapping(value="get/{id}")
    @ApiOperation(value="根据ID查询工程量清单信息",httpMethod = "GET",notes = "根据ID查询工程量清单信息")
    public BillOfQuantities get(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
        return baseService.getById(id);
    }

    @RequestMapping(value = "/deleteBillOfQuantities", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除工程量清单信息", httpMethod = "POST", notes = "逻辑删除工程量清单信息")
    public CommonResult<String> deleteBillOfQuantities(@ApiParam(name = "ids", value = "可视化分类ID集合以，隔开", required = true)
                                               @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BillOfQuantities> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }
}
