package com.artfess.yhxt.check.regular.manager.impl;


import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.SideSlopeInformationManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.SideSlopeInformation;
import com.artfess.yhxt.check.detail.dao.SideRegularCheckDetailDao;
import com.artfess.yhxt.check.detail.manager.SideRegularCheckDetailManager;
import com.artfess.yhxt.check.detail.model.SideRegularCheckDetail;
import com.artfess.yhxt.check.regular.dao.SideSlopeRegularCheckDao;
import com.artfess.yhxt.check.regular.manager.SideSlopeRegularCheckManager;
import com.artfess.yhxt.check.regular.model.SideSlopeRegularCheck;
import com.artfess.yhxt.check.regular.vo.SideSlopeRegularCheckVo;
import com.artfess.yhxt.statistics.dao.SiteStatisticDao;
import com.artfess.yhxt.statistics.model.SiteStatistic;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 边坡定期检查表 服务实现类
 *
 * @author xzh
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-08-17
 */
@Service
public class SideSlopeRegularCheckManagerImpl extends BaseManagerImpl<SideSlopeRegularCheckDao, SideSlopeRegularCheck> implements SideSlopeRegularCheckManager {
    @Resource
    private SideRegularCheckDetailManager sideRegularCheckDetailManager;
    @Resource
    private SideRegularCheckDetailDao sideRegularCheckDetailDao;
    @Resource
    private SideSlopeInformationManager slopeInformationManager;
    @Resource
    private SiteStatisticDao siteStatisticDao;
    @Resource
    private AccessoryManager accessoryManager;


    @Override
    public PageList<SideSlopeRegularCheck> querySideSlopeRegularCheck(QueryFilter<SideSlopeRegularCheck> queryFilter) {
        HashMap<String, Object> map = new HashMap<>();
        Map<String, Object> params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        IPage<SideSlopeRegularCheck> result = baseMapper.querySideSlopeRegularCheck(convert2IPage(queryFilter.getPageBean()), map, convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public void saveSideSlopeRegularCheck(SideSlopeRegularCheckVo vo) {
        SideSlopeRegularCheck sideSlopeRegularCheck = vo.getSideSlopeRegularCheck();
        sideSlopeRegularCheck.setIsDele("0");
        this.saveOrUpdate(sideSlopeRegularCheck);
        List<SideRegularCheckDetail> list = vo.getSideRegularCheckDetails();
        if (list.size() > 0) {
            for (SideRegularCheckDetail sideRegularCheckDetail : list) {
                sideRegularCheckDetail.setId(null);
                sideRegularCheckDetail.setSideSlopeRegularCheckId(sideSlopeRegularCheck.getId());
                this.sideRegularCheckDetailManager.create(sideRegularCheckDetail);
            }
        }
        //保存附件信息
        List<Accessory> accessoryList = vo.getAccessories();
        //资源ID
        String id = sideSlopeRegularCheck.getId();
        if (null !=accessoryList && accessoryList.size() > 0) {

            //获取附件信息
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveBatch(accessoryList);
        }    }

    @Override
    public void updateSideSlopeRegularCheck(SideSlopeRegularCheckVo vo) {
        SideSlopeRegularCheck sideSlopeRegularCheck = vo.getSideSlopeRegularCheck();
        this.update(sideSlopeRegularCheck);

        List<SideRegularCheckDetail> details = vo.getSideRegularCheckDetails();
        if (details.size() > 0) {
            for (SideRegularCheckDetail detail : details) {
                detail.setSideSlopeRegularCheckId(sideSlopeRegularCheck.getId());
                this.sideRegularCheckDetailManager.saveOrUpdate(detail);
            }
        }
        //保存附件信息
        List<Accessory> accessoryList = vo.getAccessories();
        //资源ID
        String id = sideSlopeRegularCheck.getId();
        if (null !=accessoryList && accessoryList.size() > 0) {
            //删除原来的附件信息
            this.accessoryManager.delAccessoryBySourceId(id);
            //获取附件信息
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveOrUpdateBatch(accessoryList);
        }
    }

    @Override
    public SideSlopeRegularCheckVo getSideSlopeRegularCheckById(String id) {
        SideSlopeRegularCheckVo sideSlopeRegularCheckVo = new SideSlopeRegularCheckVo();
        SideSlopeRegularCheck sideSlopeRegularCheck = this.getById(id);

        sideSlopeRegularCheckVo.setSideSlopeRegularCheck(sideSlopeRegularCheck);

        QueryWrapper<SideRegularCheckDetail> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(StringUtils.isNotBlank(sideSlopeRegularCheck.getId()), "SIDE_SLOPE_REGULAR_CHECK_ID_", id);
        List<SideRegularCheckDetail> detailList = this.sideRegularCheckDetailDao.selectList(queryWrapper);
        sideSlopeRegularCheckVo.setSideRegularCheckDetails(detailList);

        List<Accessory> accessories = this.accessoryManager.getAccessoryBySourceId(id);
        sideSlopeRegularCheckVo.setAccessories(accessories);
        return sideSlopeRegularCheckVo;
    }

    @Override
    public void importExcelData(MultipartFile file, SideSlopeRegularCheck parseObject) {
        Assert.notNull(parseObject, "主数据不能为空");

        try (InputStream inputStream = file.getInputStream();) {
            // 获取数据
            List<SideRegularCheckDetail> data = ExcelImportUtil.importExcel(inputStream, SideRegularCheckDetail.class, new ImportParams());
            SideSlopeRegularCheckVo vo = new SideSlopeRegularCheckVo();
            vo.setSideSlopeRegularCheck(parseObject);
            vo.setSideRegularCheckDetails(data);
            saveSideSlopeRegularCheck(vo);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveSiteStatistic(SideSlopeRegularCheck sideSlopeRegularCheck) {
        SiteStatistic siteStatistic = new SiteStatistic();
        String sideSlopeId = sideSlopeRegularCheck.getSideSlopeId();
        SideSlopeInformation sideSlopeInformation = slopeInformationManager.getById(sideSlopeId);
        siteStatistic.setRoadSegmentId(sideSlopeInformation.getRoadSegmentId());
        siteStatistic.setRoadSegmentName(sideSlopeInformation.getRoadSegmentName());
        siteStatistic.setCompanyId(sideSlopeInformation.getCompanyId());
        siteStatistic.setCompanyName(sideSlopeInformation.getCompanyName());
        siteStatistic.setSiteCode(10);
        siteStatistic.setSiteName("边坡定期检查");
        LocalDate checkDate = sideSlopeRegularCheck.getCheckDate();
        String month = checkDate.format(DateTimeFormatter.ofPattern("yyyy-MM"));
        siteStatistic.setAccDateMonth(month);
        String year = checkDate.format(DateTimeFormatter.ofPattern("yyyy"));
        siteStatistic.setAccDateYear(year);



        siteStatistic.setComplete("1");
        siteStatistic.setCompleteNo("0");
        QueryWrapper<SiteStatistic> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(StringUtils.isNotEmpty(month), "ACC_DATE_MONTH_", month);
        queryWrapper.eq(StringUtils.isNotEmpty(year), "ACC_DATE_YEAR_", year);
        queryWrapper.eq(StringUtils.isNotEmpty(sideSlopeInformation.getRoadSegmentId()), "ROAD_SEGMENT_ID_", sideSlopeInformation.getRoadSegmentId());
        queryWrapper.eq(StringUtils.isNotEmpty(sideSlopeInformation.getCompanyId()), "COMPANY_ID_", sideSlopeInformation.getCompanyId());
        queryWrapper.eq("SITE_CODE_", 10);
        queryWrapper.eq("SITE_NAME_", "边坡定期检查");
        List<SiteStatistic> siteStatistics = siteStatisticDao.selectList(queryWrapper);
        if (siteStatistics.size() > 0) {
            SiteStatistic statistic = siteStatistics.get(0);
            statistic.setComplete(String.valueOf(Integer.parseInt(statistic.getCompleteNo()) + 1));
            this.siteStatisticDao.update(siteStatistic, queryWrapper);
        } else {
            siteStatisticDao.insert(siteStatistic);
        }
    }
}
