package com.artfess.yhxt.basedata.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 沿线设施
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 王平
 * @since 2021-07-29
 */

@ApiModel(description="沿线设施")
@TableName("biz_roadside_facilities")
@JsonInclude
public class BizRoadsideFacilities extends BizModel<BizRoadsideFacilities> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "所属公司多个ID")
    @TableField("COMPANY_IDS_")
    private String companyIds;

    @ApiModelProperty(value = "所属公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "编号")
    @TableField("NUMBER_")
    private String number;

    @ApiModelProperty(value = "所在路段id(关联路段表ID)")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "所在路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "管养单位ID")
    @TableField("OFFICE_ID_")
    private String officeId;

    @ApiModelProperty(value = "管养单位名称")
    @TableField("OFFICE_NAME_")
    private String officeName;

    @ApiModelProperty(value = "名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "类型 1:立交互通2:匝道3:收费站4:服务区5:标志标牌6:防护设施7:绿化8:排水9:路面10:其他")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "类型值")
    @TableField("TYPE_VALUE_")
    private String typeValue;

    @ApiModelProperty(value = "桩号")
    @TableField("PEG_")
    private Float peg;

    @ApiModelProperty(value = "方向 1:上行方向 2:下行方向 3:上下双向 4:匝道")
    @TableField("DIRECTION_")
    private String direction;

    @ApiModelProperty(value = "方向值")
    @TableField("DIRECTION_VALUE_")
    private String directionValue;

    @ApiModelProperty(value = "详细说明")
    @TableField("EXPOUND_")
    private String expound;

    @ApiModelProperty(value = "桩号值")
    @TableField("PEG_K_")
    private String pegK;

    @ApiModelProperty(value = "经度")
    @TableField("LNG")
    private Double lng;
    @ApiModelProperty(value = "维度")
    @TableField("LAT")
    private Double lat;

    //正面图:frontView  侧面图:lateralView 二维平面图:twoDimensionalPlan
    @ApiModelProperty(value = "正面图")
    @TableField(exist = false )
    private List<Accessory> accessoriesFrontView;
    @ApiModelProperty(value = "侧面图")
    @TableField(exist = false )
    private List<Accessory> accessoriesLateralView;
    @ApiModelProperty(value = "二维平面图")
    @TableField(exist = false )
    private List<Accessory> accessoriesTwoDimensionalView;

    public List<Accessory> getAccessoriesFrontView() {
        return accessoriesFrontView;
    }

    public void setAccessoriesFrontView(List<Accessory> accessoriesFrontView) {
        this.accessoriesFrontView = accessoriesFrontView;
    }

    public List<Accessory> getAccessoriesLateralView() {
        return accessoriesLateralView;
    }

    public void setAccessoriesLateralView(List<Accessory> accessoriesLateralView) {
        this.accessoriesLateralView = accessoriesLateralView;
    }

    public List<Accessory> getAccessoriesTwoDimensionalView() {
        return accessoriesTwoDimensionalView;
    }

    public void setAccessoriesTwoDimensionalView(List<Accessory> accessoriesTwoDimensionalView) {
        this.accessoriesTwoDimensionalView = accessoriesTwoDimensionalView;
    }

    public Double getLng() {
        return lng;
    }

    public void setLng(Double lng) {
        this.lng = lng;
    }

    public Double getLat() {
        return lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getRoadSegmentId() {
        return roadSegmentId;
    }

    public void setRoadSegmentId(String roadSegmentId) {
        this.roadSegmentId = roadSegmentId;
    }

    public String getRoadSegmentName() {
        return roadSegmentName;
    }

    public void setRoadSegmentName(String roadSegmentName) {
        this.roadSegmentName = roadSegmentName;
    }

    public String getOfficeId() {
        return officeId;
    }

    public void setOfficeId(String officeId) {
        this.officeId = officeId;
    }

    public String getOfficeName() {
        return officeName;
    }

    public void setOfficeName(String officeName) {
        this.officeName = officeName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Float getPeg() {
        return peg;
    }

    public void setPeg(Float peg) {
        this.peg = peg;
    }

    public String getDirection() {
        return direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getExpound() {
        return expound;
    }

    public void setExpound(String expound) {
        this.expound = expound;
    }

    public String getPegK() {
        return pegK;
    }

    public void setPegK(String pegK) {
        this.pegK = pegK;
    }

    public String getCompanyIds() {
        return companyIds;
    }

    public void setCompanyIds(String companyIds) {
        this.companyIds = companyIds;
    }

    public String getTypeValue() {
        return typeValue;
    }

    public void setTypeValue(String typeValue) {
        this.typeValue = typeValue;
    }

    public String getDirectionValue() {
        return directionValue;
    }

    public void setDirectionValue(String directionValue) {
        this.directionValue = directionValue;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizRoadsideFacilities{" +
                "id='" + id + '\'' +
                ", companyId='" + companyId + '\'' +
                ", companyIds='" + companyIds + '\'' +
                ", companyName='" + companyName + '\'' +
                ", sn=" + sn +
                ", number='" + number + '\'' +
                ", roadSegmentId='" + roadSegmentId + '\'' +
                ", roadSegmentName='" + roadSegmentName + '\'' +
                ", officeId='" + officeId + '\'' +
                ", officeName='" + officeName + '\'' +
                ", name='" + name + '\'' +
                ", type='" + type + '\'' +
                ", peg=" + peg +
                ", direction='" + direction + '\'' +
                ", expound='" + expound + '\'' +
                ", pegK='" + pegK + '\'' +
                '}';
    }
}
