package com.artfess.yhxt.basedata.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 物资类型及数量
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xmz
 * @since 2022-04-19
 */
@ApiModel(value="BizMaterialsManagement对象", description="物资类型及数量")
@TableName("biz_materials_management")
@Data
public class BizMaterialsManagement extends BaseModel<BizMaterialsManagement> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表id")
    @TableField("STRUCTURAL_ID_")
    private String structuralId;

    @ApiModelProperty(value = "用途")
    @TableField("MATERIAL_TYPE_")
    private String materialType;

    @ApiModelProperty(value = "名称")
    @TableField("MATERIAL_TYPE_VALUE_")
    private String materialTypeValue;

    @ApiModelProperty(value = "数量")
    @TableField("QUANTITY_")
    private String quantity;

    @ApiModelProperty(value = "单位")
    @TableField("UNIT_")
    private String unit;

    @ApiModelProperty(value = "已用数量")
    @TableField("QUANTITY_USED_")
    private String quantityUsed;

    @ApiModelProperty(value = "备注")
    @TableField("REMARK_")
    private String remark;



    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizMaterialsManagement{" +
            "id=" + id +
            ", structuralId=" + structuralId +
            ", materialType=" + materialType +
            ", materialTypeValue=" + materialTypeValue +
            ", quantity=" + quantity +
            ", unit=" + unit +
        "}";
    }
}
