package com.artfess.yhxt.basedata.dao;

import com.artfess.yhxt.basedata.model.SideSlopeInformation;
import com.artfess.base.query.PageList;
import com.artfess.yhxt.basedata.vo.SideSlopCheckVo;
import com.artfess.yhxt.basedata.vo.SideSlopeRegularVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.Map;

/**
 * 边坡信息表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 向贞好
 * @since 2021-07-28
 */
public interface SideSlopeInformationDao extends BaseMapper<SideSlopeInformation> {


    IPage<SideSlopeInformation> querySideSlopeInformation(IPage<SideSlopeInformation> convert2IPage,
                                                          @Param("map") Map<String, Object> params,
                                                          @Param(Constants.WRAPPER) Wrapper<SideSlopeInformation> convert2Wrapper);


    IPage<SideSlopCheckVo> querySideSlope(IPage<SideSlopeInformation> convert2IPage,
                                          @Param("map") Map<String, Object> params,
                                          @Param(Constants.WRAPPER) Wrapper<SideSlopeInformation> convert2Wrapper);

    IPage<SideSlopeRegularVo> querySideSlopeRegularCheckVo(IPage<SideSlopeInformation> convert2IPage,
                                                           @Param("map") Map<String, Object> params,
                                                           @Param(Constants.WRAPPER) Wrapper<SideSlopeInformation> convert2Wrapper);
}
