package com.artfess.yhxt.thirdparty.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.thirdparty.model.BizTpBridgeHealth;
import com.artfess.yhxt.thirdparty.dao.BizTpBridgeHealthDao;
import com.artfess.yhxt.thirdparty.manager.BizTpBridgeHealthManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.thirdparty.model.BizTpDevice;
import com.artfess.yhxt.thirdparty.vo.AbnormalCountVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 * 第三方传输桥梁健康信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-06-15
 */
@Service
public class BizTpBridgeHealthManagerImpl extends BaseManagerImpl<BizTpBridgeHealthDao, BizTpBridgeHealth> implements BizTpBridgeHealthManager {

    @Resource
    PermissionUtils permissionUtils;
    @Resource
    BaseContext baseContext;


    /**
     * 健康信息统计
     * @param queryFilter
     * @return
     */
    @Override
    public AbnormalCountVo abnormalCountVo(QueryFilter<BizTpBridgeHealth> queryFilter) {
        HashMap<String, Object> map = new HashMap<>();
        Map<String, Object> params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())) {
            permissionUtils.addPermission(queryFilter);
        }
        PageBean pageBean = queryFilter.getPageBean();

        pageBean.setPageSize(-1);
        AbnormalCountVo countVo = baseMapper.pageCount(convert2IPage(pageBean), map, convert2Wrapper(queryFilter, currentModelClass()));
        return countVo;
    }
}
