package com.artfess.yhxt.thirdparty.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.thirdparty.vo.BridgeResourceVo;
import com.artfess.yhxt.thirdparty.vo.TpBridgeCountVo;
import com.artfess.yhxt.thirdparty.vo.TpBridgePageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.thirdparty.model.BizTpBridge;
import com.artfess.yhxt.thirdparty.manager.BizTpBridgeManager;

import java.util.List;

/**
 * 第三方传输桥梁基础信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-06-15
 */
@RestController
@RequestMapping("/bizTpBridge/v1/")
@Api(tags = "第三方传输桥梁基础信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizTpBridgeController extends BaseController<BizTpBridgeManager, BizTpBridge> {


    /**
     * 获取不同类型的桥梁数量统计
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "getBridgeCount", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取桥梁类型统计", httpMethod = "POST", notes = "获取桥梁类型统计")
    public TpBridgeCountVo getBridgeCount(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizTpBridge> queryFilter) {

        return baseService.getBridgeCount(queryFilter);
    }


    @RequestMapping(value = "pageVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "分页查询结果", httpMethod = "POST", notes = "分页查询结果")

    public PageList<TpBridgePageVo> page(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizTpBridge> queryFilter) {

        return baseService.pageVo(queryFilter);
    }



    @RequestMapping(value = "detail/{id}", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "明细", httpMethod = "GET", notes = "明细")

    public BridgeResourceVo detailById(@ApiParam(name="id", value="实体id") @PathVariable String id) {

        return baseService.detailById(id);
    }





}
