package com.artfess.yhxt.task.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.task.vo.TaskAlreadyHandleHistoryVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.task.model.TaskAlreadyHandleHistory;
import com.artfess.yhxt.task.manager.TaskAlreadyHandleHistoryManager;

/**
 * 主要是从待办处理完毕之后，向“已办”表中插入相关数据 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2021-09-16
 */
@RestController
@RequestMapping("/bizTaskAlreadyHandleHistory/v1/")
@Api(tags = "巡检已办管理接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class TaskAlreadyHandleHistoryController extends BaseController<TaskAlreadyHandleHistoryManager, TaskAlreadyHandleHistory> {
    @RequestMapping(value = "/getJson", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "分页查询已办任务管理", httpMethod = "POST")
    public PageList<TaskAlreadyHandleHistoryVo> getJson(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<TaskAlreadyHandleHistory> queryFilter) {
        queryFilter.addFilter("a.is_dele_", "0", QueryOP.EQUAL);
        PageList<TaskAlreadyHandleHistoryVo> pageList = baseService.queryTaskWaitHandleHistory(queryFilter);
        return pageList;
    }

    @RequestMapping(value = "/getListLog", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "流程日志", httpMethod = "POST")
    public PageList<TaskAlreadyHandleHistory> getListLog(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<TaskAlreadyHandleHistory> queryFilter) {
        PageList<TaskAlreadyHandleHistory> pageList = baseService.queryTaskWaitHandleLog(queryFilter);
        return pageList;
    }
}
