package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 项目合同表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-10
 */
@ApiModel(value="BizProjectContract对象", description="项目合同表")
@TableName("biz_project_contract")
@Data
public class BizProjectContract extends BizModel<BizProjectContract> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "工程表id")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "工程表name")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "合同表id")
    @TableField("CONTRACT_ID_")
    private String contractId;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "路段id")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "主管单位id")
    @TableField("OFFICE_ID_")
    private String officeId;

    @ApiModelProperty(value = "合同名称")
    @TableField("CONTRACT_NAME_")
    private String contractName;

    @ApiModelProperty(value = "合同类型")
    @TableField("CONTRACT_TYPE_")
    private String contractType;

    @ApiModelProperty(value = "第一方（甲方）")
    @TableField("FIRST_PARTY_")
    private String firstParty;

    @ApiModelProperty(value = "第一方（甲方）id")
    @TableField("FIRST_PARTY_ID_")
    private String firstPartyId;

    @ApiModelProperty(value = "第一方（甲方）ids")
    @TableField("FIRST_PARTY_IDS_")
    private String firstPartyIds;

    @ApiModelProperty(value = "第二方（乙方）")
    @TableField("SECOND_PARTY_")
    private String secondParty;

    @ApiModelProperty(value = "第二方（乙方）id")
    @TableField("SECOND_PARTY_ID_")
    private String secondPartyId;

    @ApiModelProperty(value = "第二方（乙方）ids")
    @TableField("SECOND_PARTY_IDS_")
    private String secondPartyIds;

    @ApiModelProperty(value = "第三方（丙方）")
    @TableField("THIRD_PARTY_")
    private String thirdParty;

    @ApiModelProperty(value = "第三方（丙方）id")
    @TableField("THIRD_PARTY_ID_")
    private String thirdPartyId;

    @ApiModelProperty(value = "第三方（丙方）ids")
    @TableField("THIRD_PARTY_IDS_")
    private String thirdPartyIds;

    @ApiModelProperty(value = "合同编号")
    @TableField("CONTRACT_NUMBER_")
    private String contractNumber;

    @ApiModelProperty(value = "唯一编号")
    @TableField("UNIQUE_NUMBER_")
    private String uniqueNumber;

    @ApiModelProperty(value = "分类编号")
    @TableField("CLASSIFICATION_NUMBER_")
    private String classificationNumber;

    @ApiModelProperty(value = "发起人（立项人）")
    @TableField("CONTRACT_INITIATOR_")
    private String contractInitiator;

    @ApiModelProperty(value = "合同金额")
    @TableField("CONTRACT_AMOUNT_")
    private String contractAmount;

    @ApiModelProperty(value = "保证金")
    @TableField("RETENTION_MONEY_")
    private String retentionMoney;

    @ApiModelProperty(value = "结算金额")
    @TableField("SETTLEMENT_AMOUNT_")
    private String settlementAmount;

    @ApiModelProperty(value = "合同日期（签约日期）")
    @TableField("CONTRACT_DATE_")
    private LocalDate contractDate;

    @ApiModelProperty(value = "合同内容")
    @TableField("CONTRACT_CONTENTS_")
    private String contractContents;

    @ApiModelProperty(value = "单位确定方式")
    @TableField("CONFIRMATION_MODE_")
    private String confirmationMode;

    @ApiModelProperty(value = "1-有效（默认值）、0-无效")
    @TableField("VALID_FLAG_")
    private Integer validFlag;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;


}
