package com.artfess.yhxt.contract.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 合同支付表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-06
 */
@ApiModel(value="ContractPayment对象", description="合同支付表")
@TableName("biz_contract_payment")
public class ContractPayment extends BaseModel<ContractPayment> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "对应合同ID")
    @TableField("CONTRACT_ID_")
    private String contractId;

    @ApiModelProperty(value = "支付名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "支付期数")
    @TableField("STAGE_")
    private Integer stage;

    @ApiModelProperty(value = "支付日期")
    @TableField("PAY_DATE_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private LocalDate payDate;

    @ApiModelProperty(value = "本次支付金额（元）")
    @TableField("AMOUNT_")
    private Float amount;

    @ApiModelProperty(value = "本次支付扣留保证金（元）")
    @TableField("DEPOSIT_")
    private Float deposit;

    @ApiModelProperty(value = "支付说明")
    @TableField("EXPLAIN_")
    private String explain;

    @ApiModelProperty(value = "支付期数值")
    @TableField("STAGE_VALUE_")
    private String stageValue;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getStage() {
        return stage;
    }

    public void setStage(Integer stage) {
        this.stage = stage;
    }
    public LocalDate getPayDate() {
        return payDate;
    }

    public void setPayDate(LocalDate payDate) {
        this.payDate = payDate;
    }
    public Float getAmount() {
        return amount;
    }

    public void setAmount(Float amount) {
        this.amount = amount;
    }
    public Float getDeposit() {
        return deposit;
    }

    public void setDeposit(Float deposit) {
        this.deposit = deposit;
    }
    public String getExplain() {
        return explain;
    }

    public void setExplain(String explain) {
        this.explain = explain;
    }
    public String getStageValue() {
        return stageValue;
    }

    public void setStageValue(String stageValue) {
        this.stageValue = stageValue;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "ContractPayment{" +
            "id=" + id +
            ", contractId=" + contractId +
            ", name=" + name +
            ", stage=" + stage +
            ", payDate=" + payDate +
            ", amount=" + amount +
            ", deposit=" + deposit +
            ", explain=" + explain +
            ", stageValue=" + stageValue +
        "}";
    }
}
