package com.artfess.yhxt.check.regular.dao;

import com.artfess.yhxt.check.regular.model.BridgeOftenCheck;
import com.artfess.yhxt.check.regular.model.TunnelOftenCheck;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.HashMap;
import java.util.Map;

/**
 * 隧道经常检查表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-04
 */
public interface TunnelOftenCheckDao extends BaseMapper<TunnelOftenCheck> {

    IPage<TunnelOftenCheck> queryTunnelOftenCheck(IPage<TunnelOftenCheck> convert2IPage,
                                                  @Param("map") Map<String, Object> params,
                                                  @Param(Constants.WRAPPER) Wrapper<TunnelOftenCheck> convert2Wrapper);

    @Select("SELECT * FROM BIZ_TUNNEL_OFTEN_CHECK WHERE TUNNEL_ID_ = #{id} ORDER BY CHECK_DATE_ DESC LIMIT 0,1")
    TunnelOftenCheck selectMaxcheckDate(String id);

    int countTunnelOften(@Param("ids")String tunnelIds, @Param("mouth")String mouth);
}
