package com.artfess.yhxt.check.regular.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.util.time.DateUtil;
import com.artfess.yhxt.check.regular.manager.CheckExportOftenManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author zhx
 * @create 2022/3/2
 */
@RestController
@RequestMapping("/checkExportOften/v1/")
@Api(tags = "经常检查导出-检查单")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class CheckExportOftenController {
    @Resource
    private CheckExportOftenManager checkExportOftenManager;
    @RequestMapping(value = "bridge/exportBridgeOften", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "桥梁经常检查-检查单", httpMethod = "GET", notes = "桥梁经常检查-检查单")
    public void exportBridgeOften(@ApiParam(name = "ids", value = "桥梁id用逗号分割", required = true) @RequestParam String ids, HttpServletResponse response) throws Exception {
        checkExportOftenManager.exportBridgeOften(ids, response);
    }

    @RequestMapping(value = "tunnel/exportTunnelOften", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "隧道经常检查-检查单", httpMethod = "GET", notes = "隧道经常检查-检查单")
    public void exportTunnelOften(@ApiParam(name = "ids", value = "隧道id用逗号分割", required = true) @RequestParam String ids, HttpServletResponse response) throws Exception {
        checkExportOftenManager.exportTunnelOften(ids, response);
    }

    @RequestMapping(value = "culvert/exportCulvertOften", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "涵洞经常检查-检查单", httpMethod = "GET", notes = "涵洞经常检查-检查单")
    public void exportCulvertOften(@ApiParam(name = "ids", value = "涵洞id用逗号分割", required = true) @RequestParam String ids, HttpServletResponse response) throws Exception {
        checkExportOftenManager.exportCulvertOften(ids, response);
    }

    @RequestMapping(value = "sideSlope/exportSideSlopeOften", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "边坡经常检查-检查单", httpMethod = "GET", notes = "边坡经常检查-检查单")
    public void exportSideSlopeOften(@ApiParam(name = "ids", value = "边坡id用逗号分割", required = true) @RequestParam String ids, HttpServletResponse response) throws Exception {
        checkExportOftenManager.exportSideSlopeOften(ids, response);
    }

    @RequestMapping(value = "bridge/exportBridgeOftenHistory", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "桥梁经常检查-历史检查单", httpMethod = "GET", notes = "桥梁经常检查-历史检查单")
    public void exportBridgeOftenHistory( String bridgeId,
                                          String pid, String ids,
                                          String timeGrateThan,
                                          String timeLessThan,
                                         HttpServletResponse response) throws Exception {
        if(null == pid){
            pid =bridgeId;
        }

        if(null ==timeGrateThan || "".equals(timeGrateThan) ){

            checkExportOftenManager.exportBridgeOftenHistory(pid,ids, null, null,response);
        }else {
            Date date1 = transferString2Date(timeGrateThan);
            Date date2 = transferString2Date(timeLessThan);
            checkExportOftenManager.exportBridgeOftenHistory(pid,ids, date1, date2,response);
        }


    }

    @RequestMapping(value = "tunnel/exportTunnelOftenHistory", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "隧道经常检查-历史检查单", httpMethod = "GET", notes = "隧道经常检查-历史检查单")
    public void exportTunnelOftenHistory(String tunnelId,
                                         String pid,
                                         String ids,
                                        String  timeGrateThan,
                                         String timeLessThan,
                                         HttpServletResponse response) throws Exception {
        if(null == pid){
            pid =tunnelId;
        }

        if(null ==timeGrateThan || "".equals(timeGrateThan) ){


            checkExportOftenManager.exportTunnelOftenHistory(pid,ids, null, null,response);
        }else {
            Date date1 = transferString2Date(timeGrateThan);
            Date date2 = transferString2Date(timeLessThan);
            checkExportOftenManager.exportTunnelOftenHistory(pid,ids, date1, date2,response);
        }
    }

    @RequestMapping(value = "culvert/exportCulvertOftenHistory", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "涵洞经常检查-历史检查单", httpMethod = "GET", notes = "涵洞经常检查-历史检查单")
    public void exportCulvertOftenHistory( String culvertId,
                                           String pid,
                                           String ids,
                                           String timeGrateThan,
                                           String timeLessThan,
                                          HttpServletResponse response) throws Exception {

        if(null == pid){
            pid =culvertId;
        }

        if(null ==timeGrateThan || "".equals(timeGrateThan) ){


            checkExportOftenManager.exportCulvertOftenHistory(pid,ids, null, null,response);
        }else {
            Date date1 = transferString2Date(timeGrateThan);
            Date date2 = transferString2Date(timeLessThan);
            checkExportOftenManager.exportCulvertOftenHistory(pid,ids, date1, date2,response);
        }
    }

    @RequestMapping(value = "sideSlope/exportSideSlopeOftenHistory", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "边坡经常检查-历史检查单", httpMethod = "GET", notes = "边坡经常检查-历史检查单")
    public void exportSideSlopeOftenHistory(String pid,
                                            String sideSlopeId,
                                            String ids,
                                            String timeGrateThan,
                                            String timeLessThan,
                                            HttpServletResponse response) throws Exception {
        if(null == pid){
            pid =sideSlopeId;
        }
        if(null ==timeGrateThan || "".equals(timeGrateThan) ){


            checkExportOftenManager.exportSideSlopeOftenHistory(pid,ids, null, null,response);
        }else {
            Date date1 = transferString2Date(timeGrateThan);
            Date date2 = transferString2Date(timeLessThan);
            checkExportOftenManager.exportSideSlopeOftenHistory(pid,ids, date1, date2,response);
        }
    }

    public  Date transferString2Date(String s) {
        Date date = new Date();
        try {
            date = new SimpleDateFormat("yyyy-MM-dd").parse(s);
        } catch (Exception e) {
//            throw new Exception(e.getMessage());
        }
        return date;
    }

}
