package com.artfess.yhxt.basedata.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.model.MigrantBuildersInformation;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.basedata.vo.HumanCountVo;

import com.artfess.yhxt.basedata.vo.MigrantBuildersInformationVo;

import java.util.List;


/**
 * 施工人员管理表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-10-12
 */
public interface MigrantBuildersInformationManager extends BaseManager<MigrantBuildersInformation> {
    PageList<MigrantBuildersInformation> queryMigrantBuildersInformation(QueryFilter<MigrantBuildersInformation> queryFilter);

    MigrantBuildersInformation getMigrantBuildersById(String id);

    /**
     * 保存施工人员及附件信息
     * @param migrantBuildersInformationVo
     */
    void saveVo(MigrantBuildersInformationVo migrantBuildersInformationVo);

    /**
     * 修改施工人员及附件信息
     * @param migrantBuildersInformationVo
     */
    void updateVo(MigrantBuildersInformationVo migrantBuildersInformationVo);

    /**
     * 根据Id查询施工人员及附件信息
     * @param id
     * @return
     */
    MigrantBuildersInformationVo getByIdVo(String id);

    List<HumanCountVo> getCountVo();


}
