package com.artfess.yhxt.basedata.controller;


import com.artfess.yhxt.basedata.manager.BizRoadsideFacilitiesManager;
import com.artfess.yhxt.basedata.model.BizRoadsideFacilities;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.yhxt.statistics.vo.Org4bridgeInfoVO;
import com.artfess.yhxt.statistics.vo.Org4roadSideVO;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * 沿线设施 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-07-29
 */
@RestController
@Api(tags = "沿线设施管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RequestMapping("/bizRoadsideFacilities/bizRoadsideFacilitiesManager/v1/")
public class BizRoadsideFacilitiesController extends BaseController<BizRoadsideFacilitiesManager, BizRoadsideFacilities> {
    @Resource
    BizRoadsideFacilitiesManager bizRoadsideFacilitiesManager;
    /**
     * 沿线设施管理列表(分页条件查询)数据
     *
     * @param queryFilter
     * @return
     * @throws Exception PageJson
     * @throws
     */
    
    @PostMapping("/list")
    @ApiOperation(value = "沿线设施管理数据列表", httpMethod = "POST", notes = "获取沿线设施管理列表")
    public PageList<BizRoadsideFacilities> list(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<BizRoadsideFacilities> queryFilter) throws Exception {
        return bizRoadsideFacilitiesManager.query(queryFilter);
    }


    @RequestMapping(value = "getCountVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取沿线设施统计", httpMethod = "POST", notes = "获取沿线设施统计")
    public List<Org4roadSideVO> getCountVo() throws Exception {
        return baseService.getRoadSideCount();
    }

    /**
     * 沿线设施管理明细页面
     *
     * @param id
     * @return
     * @throws Exception ModelAndView
     */
    @GetMapping(value = "/get/{id}")
    @ApiOperation(value = "沿线设施管理数据详情", httpMethod = "GET", notes = "沿线设施管理数据详情")
    public BizRoadsideFacilities get(@ApiParam(name = "id", value = "业务对象主键", required = true) @PathVariable String id) throws Exception {
        return bizRoadsideFacilitiesManager.getByFacilitiesId(id);
    }

    /**
     * 新增沿线设施管理
     *
     * @param BizRoadsideFacilities
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "/save")
    @ApiOperation(value = "新增,更新沿线设施管理数据", httpMethod = "POST", notes = "新增,更新沿线设施管理数据")
    public CommonResult<String> save(@ApiParam(name = "BizRoadsideFacilities", value = "沿线设施管理业务对象", required = true) @RequestBody BizRoadsideFacilities BizRoadsideFacilities) throws Exception {
        String msg = "添加沿线设施管理成功";
        if (StringUtil.isEmpty(String.valueOf(BizRoadsideFacilities.getId()))) {
            BizRoadsideFacilities.setIsDele("0");
            HashMap<String, Object> map = new HashMap<>();
            IUser user= ContextUtil.getCurrentUser();
            if(ObjectUtils.isNotEmpty(user)){
                map.put("tenant_id_", user.getTenantId());
            }
            int nextSequence =baseService.getNextSequence(map);
            BizRoadsideFacilities.setSn(nextSequence);
            bizRoadsideFacilitiesManager.saveRoadside(BizRoadsideFacilities);
        } else {
            bizRoadsideFacilitiesManager.updateRoadside(BizRoadsideFacilities);
            msg = "更新沿线设施管理成功";
        }
        return new CommonResult<String>(msg);
    }

    /**
     * 删除沿线设施管理记录
     *
     * @param id
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/remove/{id}")
    @ApiOperation(value = "删除沿线设施管理记录", httpMethod = "DELETE", notes = "删除沿线设施管理记录")
    public CommonResult<String> remove(@ApiParam(name = "id", value = "业务主键", required = true) @PathVariable String id) throws Exception {
        bizRoadsideFacilitiesManager.remove(id);
        return new CommonResult<String>(true, "删除成功");
    }

    /**
     * 批量删除沿线设施管理记录
     *
     * @param ids
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除沿线设施管理记录", httpMethod = "DELETE", notes = "批量删除沿线设施管理记录")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        bizRoadsideFacilitiesManager.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true, "删除成功");
    }

    @RequestMapping(value="/getList",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "不分页查询沿线设施明细信息",httpMethod = "POST")
    public PageList<BizRoadsideFacilities> getList(@ApiParam(name="queryFilter", value="不分页查询信息") @RequestBody QueryFilter<BizRoadsideFacilities> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE);
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        PageList<BizRoadsideFacilities>   road = baseService.queryBizRoadsideFacilities(queryFilter);
        return road;
    }

    @RequestMapping(value="/getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询沿线设施明细信息",httpMethod = "POST")
    public PageList<BizRoadsideFacilities> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizRoadsideFacilities> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageList<BizRoadsideFacilities> pageList = baseService.queryBizRoadsideFacilities(queryFilter);
        return  pageList;
    }

    @RequestMapping(value = "updateBatch", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除", httpMethod = "POST", notes = "逻辑删除")
    public CommonResult<String> updateBatchBizRoadsideFacilities(@ApiParam(name = "id", value = "沿线设施ID", required = true) @RequestParam(value = "id", required = true) String id) throws Exception {

        if (StringUtils.isNotBlank(id))
            bizRoadsideFacilitiesManager.updateBizRoadsideFacilities(id);
        return new CommonResult<>(true, "删除成功");
    }

    @RequestMapping(value = "updateRoadsideFacilities", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量逻辑删除", httpMethod = "DELETE", notes = "批量逻辑删除")
    public CommonResult<String> updateRoadsideFacilities(
            @ApiParam(name = "ids", value = "沿线设施ID集合以，隔开", required = true)
            @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizRoadsideFacilities> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            bizRoadsideFacilitiesManager.update(null, updateWrapper);

        }

        return new CommonResult<>(true, "批量删除成功");
    }

    @RequestMapping(value = "/updateBySn", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "修改排序号", httpMethod = "POST")
    public CommonResult<String> updateBySn(@ApiParam(name = "params", value = "排序参数：Key：ID，Value：排序号") @RequestBody HashMap<String, Integer> params) throws Exception {
        baseService.updateSequence(params);
        return new CommonResult<>(true, "排序完成");
    }
}
