/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.id.IdGenerator;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.constants.CategoryConstants;
import com.artfess.sysConfig.persistence.manager.DataDictManager;
import com.artfess.sysConfig.persistence.manager.SysTypeManager;
import com.artfess.sysConfig.persistence.model.DataDict;
import com.artfess.sysConfig.persistence.model.SysType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/sys/dataDict/v1"})
@Api(tags={"\u6570\u636e\u5b57\u5178"})
@ApiGroup(group={"group_system"})
public class DataDictController
extends BaseController<DataDictManager, DataDict> {
    @Resource
    DataDictManager dataDictManager;
    @Resource
    SysTypeManager sysTypeManager;
    @Resource
    IdGenerator idGenerator;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5b57\u5178\u5217\u8868", httpMethod="POST", notes="\u5b57\u5178\u5217\u8868")
    @ResponseBody
    public PageList<DataDict> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<DataDict> queryFilter) throws Exception {
        return this.dataDictManager.query(queryFilter);
    }

    @RequestMapping(value={"dataDictEdit"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7f16\u8f91\u6570\u636e\u5b57\u5178\u4fe1\u606f\u9875\u9762", httpMethod="GET", notes="\u7f16\u8f91\u6570\u636e\u5b57\u5178\u4fe1\u606f\u9875\u9762")
    public Map<String, Object> edit(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id, @ApiParam(name="isAdd", value="\u662f\u5426\u662f\u6dfb\u52a0") @RequestParam int isAdd, @ApiParam(name="isRoot", value="\u662f\u5426\u662f\u6839\u8282\u70b9", required=false) @RequestParam int isRoot) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isAdd", isAdd);
        DataDict dataDict = null;
        if (isRoot == 1 && isAdd == 1) {
            map.put("typeId", id);
            map.put("parentId", id);
            return map;
        }
        if (isAdd == 1 && StringUtil.isNotEmpty((String)id)) {
            map.put("parentId", id);
            dataDict = (DataDict)this.dataDictManager.get((Serializable)((Object)id));
            map.put("typeId", dataDict.getTypeId());
            return map;
        }
        if (StringUtil.isNotEmpty((String)id)) {
            dataDict = (DataDict)this.dataDictManager.get((Serializable)((Object)id));
            map.put("dataDict", dataDict);
            return map;
        }
        return map;
    }

    @RequestMapping(value={"getByTypeId"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bid\u83b7\u53d6\u5b57\u5178", httpMethod="POST", notes="\u6839\u636e\u5206\u7c7bid\u83b7\u53d6\u5b57\u5178")
    @ResponseBody
    public List<DataDict> getByTypeId(@ApiParam(name="typeId", value="\u5206\u7c7bid", required=true) @RequestBody String typeId) throws Exception {
        if (StringUtil.isEmpty((String)typeId)) {
            return null;
        }
        SysType dictType = (SysType)this.sysTypeManager.get((Serializable)((Object)typeId));
        return this.getDataDict(dictType, true);
    }

    @RequestMapping(value={"getByTypeKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bkey\u83b7\u53d6\u5b57\u5178", httpMethod="GET", notes="\u6839\u636e\u5206\u7c7bkey\u83b7\u53d6\u5b57\u5178")
    public List<DataDict> getByTypeKey(@ApiParam(name="typeKey", value="\u5206\u7c7bid", required=true) @RequestParam String typeKey) throws Exception {
        if (StringUtil.isEmpty((String)typeKey)) {
            return null;
        }
        SysType dictType = this.sysTypeManager.getByKey(typeKey);
        return this.getDataDict(dictType, false);
    }

    @RequestMapping(value={"getByTypeIdForComBo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bid\u83b7\u53d6\u5b57\u5178(ComBo)", httpMethod="POST", notes="\u6839\u636e\u5206\u7c7bid\u83b7\u53d6\u5b57\u5178(ComBo)")
    public List<DataDict> getByTypeIdForComBo(@ApiParam(name="typeId", value="\u5206\u7c7bid", required=true) @RequestBody String typeId) throws Exception {
        if (StringUtil.isEmpty((String)typeId)) {
            return null;
        }
        SysType dictType = (SysType)this.sysTypeManager.get((Serializable)((Object)typeId));
        List<DataDict> list = this.getDataDict(dictType, false);
        List rtnList = BeanUtils.listToTree(list);
        return rtnList;
    }

    @RequestMapping(value={"getByTypeKeyForComBo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7groupKey\u3001typeKey\u83b7\u53d6\u6570\u636e\u5b57\u5178", httpMethod="POST", notes="\u901a\u8fc7groupKey\u3001typeKey\u83b7\u53d6\u6570\u636e\u5b57\u5178")
    public List<DataDict> getByTypeKeyForComBo(@ApiParam(name="typeKey", value="\u5206\u7c7bkey", required=true) @RequestParam String typeKey) throws Exception {
        if (StringUtil.isEmpty((String)typeKey)) {
            return null;
        }
        SysType dictType = this.sysTypeManager.getByTypeKeyAndGroupKey(CategoryConstants.CAT_DIC.key(), typeKey);
        List<DataDict> list = this.getDataDict(dictType, false);
        List rtnList = BeanUtils.listToTree(list);
        return rtnList;
    }

    @RequestMapping(value={"getMoibleComBoByTypeKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7typeKey\u83b7\u53d6\u6570\u636e\u5b57\u5178", httpMethod="GET", notes="\u901a\u8fc7typeKey\u83b7\u53d6\u6570\u636e\u5b57\u5178")
    public Map<String, Object> getMoibleComBoByTypeKey(@ApiParam(name="typeKey", value="\u5206\u7c7bkey", required=true) @RequestParam String typeKey) throws Exception {
        if (StringUtil.isEmpty((String)typeKey)) {
            return null;
        }
        SysType dictType = this.sysTypeManager.getByTypeKeyAndGroupKey(CategoryConstants.CAT_DIC.key(), typeKey);
        List<DataDict> list = this.getDataDict(dictType, false);
        List rtnList = BeanUtils.listToTree(list);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataDictList", rtnList);
        map.put("dictType", dictType);
        return map;
    }

    private List<DataDict> getDataDict(SysType dictType, Boolean tileNeedRoot) {
        if (BeanUtils.isEmpty((Object)dictType)) {
            return null;
        }
        String typeId = dictType.getId();
        List dataDictList = this.dataDictManager.getByTypeId(typeId);
        ArrayList<DataDict> list = new ArrayList<DataDict>();
        for (DataDict entity : dataDictList) {
            DataDict dataDicts = new DataDict();
            dataDicts = entity;
            dataDicts.setOpen("true");
            List listDataDict = this.dataDictManager.getFirstChilsByParentId(dataDicts.getId());
            if (listDataDict != null && listDataDict.size() == 0) {
                dataDicts.setIsParent("false");
            }
            list.add(dataDicts);
        }
        if (tileNeedRoot.booleanValue()) {
            DataDict dict = new DataDict();
            dict.setId(dictType.getId());
            dict.setParentId("-1");
            dict.setName(dictType.getName());
            dict.setTypeId(typeId);
            dict.setKey("");
            dict.setOpen("true");
            list.add(dict);
        }
        return list;
    }

    @RequestMapping(value={"dataDictGet"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u5b57\u5178\u660e\u7ec6\u9875\u9762", httpMethod="POST", notes="\u6570\u636e\u5b57\u5178\u660e\u7ec6\u9875\u9762")
    public DataDict get(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestBody String id) throws Exception {
        DataDict dataDict = new DataDict();
        if (StringUtil.isNotEmpty((String)id)) {
            dataDict = (DataDict)this.dataDictManager.get((Serializable)((Object)id));
        }
        return dataDict;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u5b57\u5178\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u6570\u636e\u5b57\u5178\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="dataDict", value="\u5b57\u5178", required=true) @RequestBody DataDict dataDict) throws Exception {
        String id = dataDict.getId();
        try {
            if (StringUtil.isEmpty((String)id)) {
                DataDict dict = this.dataDictManager.getByDictKey(dataDict.getTypeId(), dataDict.getKey());
                if (dict != null) {
                    return new CommonResult(false, "\u8be5\u5b57\u5178\u9879\u503c\u5df2\u7ecf\u5b58\u5728");
                }
                dataDict.setId(this.idGenerator.getSuid());
                this.dataDictManager.create((Model)dataDict);
            } else {
                DataDict dict;
                if (!((DataDict)this.dataDictManager.get((Serializable)((Object)id))).getKey().equals(dataDict.getKey()) && (dict = this.dataDictManager.getByDictKey(dataDict.getTypeId(), dataDict.getKey())) != null) {
                    return new CommonResult(false, "\u8be5\u5b57\u5178\u9879\u503c\u5df2\u7ecf\u5b58\u5728");
                }
                this.dataDictManager.update((Model)dataDict);
            }
            return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(true, "\u4fdd\u5b58\u5931\u8d25");
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6570\u636e\u5b57\u5178", httpMethod="DELETE", notes="\u5220\u9664\u6570\u636e\u5b57\u5178")
    public CommonResult<String> remove(@ApiParam(name="id", value="\u5b57\u5178", required=true) @RequestParam String id) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)id);
            this.dataDictManager.removeByIds(aryIds);
            return new CommonResult(true, "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(true, "\u5220\u9664\u5931\u8d25");
        }
    }

    @RequestMapping(value={"getDataDictByTypeId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7b\u6570\u636e\u5b57\u5178", httpMethod="GET")
    public List<DataDict> getDataDictByType(@ApiParam(name="typeId", value="\u5b57\u5178", required=true) @RequestBody String typeId) throws Exception {
        List dataDictList = this.dataDictManager.getByTypeId(typeId);
        List rtnList = BeanUtils.listToTree((List)dataDictList);
        return rtnList;
    }

    @RequestMapping(value={"sortList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6392\u5e8f\u5217\u8868\u9875\u9762", httpMethod="POST")
    public List<DataDict> sortList(@ApiParam(name="id", value="\u5b57\u5178", required=false, defaultValue="-1") @RequestBody String id) throws Exception {
        List dataDictList = this.dataDictManager.getFirstChilsByParentId(id);
        return dataDictList;
    }

    @RequestMapping(value={"sort"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6392\u5e8f", httpMethod="POST")
    public CommonResult<String> sort(@ApiParam(name="dicIds", value="\u5b57\u5178", required=true) @RequestBody String[] dicIds) throws Exception {
        try {
            if (BeanUtils.isNotEmpty((Object)dicIds)) {
                for (int i = 0; i < dicIds.length; ++i) {
                    String dicId = dicIds[i];
                    int sn = i + 1;
                    this.dataDictManager.updSn(dicId, sn);
                }
            }
        }
        catch (Exception e) {
            return new CommonResult(true, "\u6392\u5e8f\u5931\u8d25");
        }
        return new CommonResult(true, "\u6392\u5e8f\u6210\u529f");
    }

    @RequestMapping(value={"removeByTypeId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bid\u5220\u9664\u5206\u7c7b\u4e0b\u7684\u5b57\u5178", httpMethod="GET")
    public CommonResult<String> removeByTypeIds(@ApiParam(name="typeIds", value="\u5206\u7c7bid", required=true) @RequestParam String typeIds) throws Exception {
        return this.dataDictManager.removeByTypeIds(typeIds);
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u5b57\u5178\u5bfc\u5165", httpMethod="POST", notes="\u6570\u636e\u5b57\u5178\u5bfc\u5165")
    public CommonResult<String> importData(@ApiParam(name="files", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody List<MultipartFile> file, @ApiParam(name="typeId", value="\u6570\u636e\u5b57\u5178\u5206\u7c7bid", required=true) @RequestParam String typeId) throws Exception {
        this.dataDictManager.importData(file, typeId);
        return new CommonResult(true, "\u5bfc\u5165\u6570\u636e\u5b57\u5178\u6210\u529f");
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u5b57\u5178\u5bfc\u51fa", httpMethod="GET", notes="\u6570\u636e\u5b57\u5178\u5bfc\u51fa")
    public void export(@ApiParam(name="typeId", value="\u7c7b\u578bID") @RequestParam String typeId, HttpServletResponse response) throws Exception {
        SysType sysType = (SysType)this.sysTypeManager.get((Serializable)((Object)typeId));
        List<DataDict> dataDict = this.getDataDict(sysType, true);
        LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
        exportMap.put("parentKey", "\u7236\u8282\u70b9key");
        exportMap.put("typeKey", "\u5206\u7c7bkey");
        exportMap.put("typeName", "\u5206\u7c7b\u540d\u79f0");
        ArrayList list = new ArrayList();
        for (DataDict dict : dataDict) {
            if (StringUtil.isEmpty((String)dict.getKey())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("parentKey", this.getKeyFromList(dict.getParentId(), dataDict));
            map.put("typeKey", dict.getKey());
            map.put("typeName", dict.getName());
            list.add(map);
        }
        HSSFWorkbook exportFile = ExcelUtil.exportExcel((String)"\u6570\u636e\u5b57\u5178", (int)dataDict.size(), exportMap, list);
        ExcelUtil.downloadExcel((HSSFWorkbook)exportFile, (String)"\u5b57\u5178\u5bfc\u51fa", (HttpServletResponse)response);
    }

    private String getKeyFromList(String id, List<DataDict> list) {
        if (StringUtil.isEmpty((String)id)) {
            return "";
        }
        for (DataDict dataDict : list) {
            if (!id.equals(dataDict.getId())) continue;
            return dataDict.getKey();
        }
        return "";
    }
}

