/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.security.util;

import com.artfess.base.manager.CommonManager;
import com.artfess.base.util.DESUtils;
import com.artfess.base.util.DateUtils;
import com.artfess.security.manager.SysAuthorizationManager;
import com.artfess.security.model.SysAuthorization;
import com.artfess.security.util.ResultCode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class AuthorCheck {
    public static final String ROOT_PATH = System.getProperty("user.dir");
    public static final String DATA_TEMP_FILE = "tempFile";
    public static final String TEMP_DATA_EXCEL = ROOT_PATH + File.separator + "tempFile";
    protected JdbcTemplate jdbcTemplate;
    @Resource
    CommonManager commonManager;
    @Autowired
    private SysAuthorizationManager systemAuthorizationManager;
    public static String FILE_PATH = TEMP_DATA_EXCEL + File.separator + "plat2021.data";
    public static String FILE_PATH_LIC = TEMP_DATA_EXCEL + File.separator + "plat2021.lic";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String redFileStr() {
        String registerContent = "";
        StringBuffer sb = new StringBuffer();
        ClassPathResource resource = new ClassPathResource(FILE_PATH);
        File file = null;
        try {
            file = resource.getFile();
        }
        catch (IOException e) {
            return registerContent;
        }
        if (!file.exists()) {
            registerContent = "";
        } else {
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
                registerContent = br.readLine();
                if (registerContent == null || registerContent.trim().length() == 0) {
                    registerContent = "";
                }
            }
            catch (IOException e) {
                registerContent = "";
            }
        }
        return registerContent;
    }

    public static String getDesStr(String registerContent) {
        return DESUtils.myDecrypt((String)registerContent.split("/")[1]);
    }

    public static Map<String, String> getInfo(String desStr) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String[] infoArr = AuthorCheck.getDesStr(desStr).split(",");
            String deptName = infoArr[0];
            String version = infoArr[1];
            String type = infoArr[2];
            String install = infoArr[3];
            String endDay = infoArr[4];
            String mac = infoArr[5];
            String ip = infoArr[6];
            String user = infoArr[8];
            map.put("deptName", deptName);
            map.put("version", version);
            map.put("install", install);
            map.put("type", type);
            map.put("endDay", endDay);
            map.put("mac", mac);
            map.put("ip", ip);
            map.put("user", user);
        }
        catch (RuntimeException e) {
            System.out.println("\u89e3\u6790\u51fa\u9519\u3002");
        }
        return map;
    }

    public static Map<String, String> getMapInfo() {
        String registerContent = AuthorCheck.redFileStr();
        return AuthorCheck.getInfo(registerContent);
    }

    public static int checkDate(String day) {
        try {
            Date newDate = new Date();
            Date checkDate = DateUtils.str2Date((String)day);
            if (checkDate.before(newDate)) {
                return 0;
            }
            return AuthorCheck.getGapCount(newDate, checkDate);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean checkSystemUpdate() {
        try {
            Date newDate = new Date();
            String sql = "select max(EXECUTION_TIME_) maxdate from portal_sys_login_logs";
            List list = this.commonManager.query(sql);
            if (list.size() == 0) {
                return false;
            }
            String maxdate = ((Map)list.get(0)).get("maxdate").toString();
            Date checkDate = DateUtils.str2Date((String)maxdate);
            return !newDate.before(checkDate);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getGapCount(Date startDate, Date endDate) {
        long da = endDate.getTime() - startDate.getTime();
        return (int)(da / 86400000L);
    }

    public SysAuthorization redFileToObject() {
        try {
            SysAuthorization entity = new SysAuthorization();
            File file = new File(FILE_PATH);
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
            entity = (SysAuthorization)((Object)ois.readObject());
            entity.setDeptName(DESUtils.myDecrypt((String)entity.getDeptName()));
            entity.setVersionCode(DESUtils.myDecrypt((String)entity.getVersionCode()));
            entity.setType(DESUtils.myDecrypt((String)entity.getType()));
            entity.setInstallDate(DESUtils.myDecrypt((String)entity.getInstallDate()));
            entity.setEndDate(DESUtils.myDecrypt((String)entity.getEndDate()));
            if (StringUtils.isNotBlank((CharSequence)entity.getTel())) {
                entity.setTel(DESUtils.myDecrypt((String)entity.getTel()));
            }
            entity.setUser(DESUtils.myDecrypt((String)entity.getUser()));
            entity.setSystemType(DESUtils.myDecrypt((String)entity.getSystemType()));
            entity.setUserNum(DESUtils.myDecrypt((String)entity.getUserNum()));
            entity.setOgnNum(DESUtils.myDecrypt((String)entity.getOgnNum()));
            entity.setTenantNum(DESUtils.myDecrypt((String)entity.getTenantNum()));
            ois.close();
            return entity;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public SysAuthorization redFileToObject(File file) {
        try {
            SysAuthorization entity = new SysAuthorization();
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
            entity = (SysAuthorization)((Object)ois.readObject());
            entity.setDeptName(DESUtils.myDecrypt((String)entity.getDeptName()));
            entity.setVersionCode(DESUtils.myDecrypt((String)entity.getVersionCode()));
            entity.setType(DESUtils.myDecrypt((String)entity.getType()));
            entity.setInstallDate(DESUtils.myDecrypt((String)entity.getInstallDate()));
            entity.setEndDate(DESUtils.myDecrypt((String)entity.getEndDate()));
            entity.setSystemType(DESUtils.myDecrypt((String)entity.getSystemType()));
            entity.setTel(DESUtils.myDecrypt((String)entity.getTel()));
            entity.setUser(DESUtils.myDecrypt((String)entity.getUser()));
            entity.setUserNum(DESUtils.myDecrypt((String)entity.getUserNum()));
            entity.setOgnNum(DESUtils.myDecrypt((String)entity.getOgnNum()));
            entity.setTenantNum(DESUtils.myDecrypt((String)entity.getTenantNum()));
            ois.close();
            return entity;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String newCheck() {
        SysAuthorization registerEntity = this.redFileToObject();
        if (null == registerEntity) {
            return (Object)((Object)ResultCode.NO_DECRYPT_ERROR) + ":" + ResultCode.NO_DECRYPT_ERROR.getMessage();
        }
        if ("2".equals(registerEntity.getType())) {
            return (Object)((Object)ResultCode.SUCCESS) + ":" + ResultCode.SUCCESS.getMessage();
        }
        boolean systemDate = this.checkSystemUpdate();
        if (!systemDate) {
            return (Object)((Object)ResultCode.NO_DECRYPT_ERROR) + ":" + ResultCode.NO_DECRYPT_ERROR.getMessage();
        }
        int dayCount = AuthorCheck.checkDate(registerEntity.getEndDate());
        if (dayCount == 0) {
            return (Object)((Object)ResultCode.NO_DECRYPT_DATE_LONG) + ":" + ResultCode.NO_DECRYPT_DATE_LONG.getMessage();
        }
        if (dayCount <= 7) {
            return (Object)((Object)ResultCode.NO_DECRYPT_WILL_DATE_LONG) + ":" + ResultCode.NO_DECRYPT_WILL_DATE_LONG.getMessage().replace("{day}", String.valueOf(dayCount));
        }
        if (!"\u8bd5\u7528\u5355\u4f4d".equals(registerEntity.getDeptName())) {
            SysAuthorization commonBasicEntity = this.systemAuthorizationManager.getByName(registerEntity.getDeptName());
            if (null == commonBasicEntity) {
                return (Object)((Object)ResultCode.NO_DECRYPT_SYSTEM) + ":" + ResultCode.NO_DECRYPT_SYSTEM.getMessage();
            }
            if (!commonBasicEntity.getDeptName().equals(registerEntity.getDeptName())) {
                return (Object)((Object)ResultCode.NO_DECRYPT_SYSTEM) + ":" + ResultCode.NO_DECRYPT_SYSTEM.getMessage();
            }
        }
        return (Object)((Object)ResultCode.SUCCESS) + ":" + ResultCode.SUCCESS.getMessage();
    }

    public static void main(String[] args) {
        AuthorCheck authorCheck = new AuthorCheck();
        System.out.println(authorCheck.newCheck());
    }
}

