package com.artfess.yhxt.statistics.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.api.impl.var.CurrentUserIdVar;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.manager.*;
import com.artfess.yhxt.basedata.model.*;
import com.artfess.yhxt.check.regular.manager.BridgeOftenCheckManager;
import com.artfess.yhxt.check.regular.model.BridgeOftenCheck;
import com.artfess.yhxt.specialcheck.manager.BizMqiCheckDataManager;
import com.artfess.yhxt.specialcheck.manager.BizMqiCheckDetailManager;
import com.artfess.yhxt.specialcheck.manager.SiteInspectionManager;
import com.artfess.yhxt.specialcheck.model.BizMqiCheckData;
import com.artfess.yhxt.specialcheck.model.BizMqiCheckDetail;
import com.artfess.yhxt.specialcheck.model.SiteInspection;
import com.artfess.yhxt.specialcheck.vo.BizMqiCheckDataVo;
import com.artfess.yhxt.statistics.dao.StatisticalStatementDao;
import com.artfess.yhxt.statistics.manager.StatisticalStatementManager;
import com.artfess.yhxt.statistics.vo.*;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author zhx
 * @create 2022/1/6
 */
@Service
public class StatisticalStatementManagerImpl implements StatisticalStatementManager {
    @Resource
    StatisticalStatementDao statisticalStatementDao;
    @Resource
    BizCourseDetailsManager bizCourseDetailsManager;
    @Resource
    RoadManager roadManager;
    @Resource
    SiteInspectionManager siteInspectionManager;
    @Resource
    BridgeInformationManager bridgeInformationManager;
    @Resource
    TunnelInformationManager tunnelInformationManager;
    @Resource
    BizCulvertInformationManager culvertInformationManager;
    @Resource
    SideSlopeInformationManager sideSlopeInformationManager;
    @Resource
    BaseContext baseContext;
    @Resource
    OrgManager orgManager;
    @Resource
    OrgDao orgDao;
    @Resource
    BizMqiCheckDataManager bizMqiCheckDataManager;


    @Override
    public Map<String, Object> countDisease(Map<String, Object> map) {
        Map<String, Object> hashMap = new HashMap<>();
        //根据检测类别统计
        DiseaseCategoryVo diseaseCategory = statisticalStatementDao.countDiseaseCategory(map);
        //处理情况
        DiseaseHandlingSituationVo diseaseHandlingSituation = statisticalStatementDao.countDiseaseHandlingSituation(map);
        //病害类别
        QueryWrapper<BizCourseDetails> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("PCODE_", "CBKM");
        queryWrapper.eq("IS_DELE_", "0");
        List<BizCourseDetails> list = bizCourseDetailsManager.list(queryWrapper);
        Map<String, Object> subjectMap = new HashMap<String, Object>();
        list.forEach(s -> {
            Integer count = statisticalStatementDao.countDiseaseSubject(s.getSubjectCode(), map);
            subjectMap.put(s.getSubjectName(), count);
        });
        //道路病害部位
        DiseasePositionVo diseasePosition = statisticalStatementDao.countPosition(map);
        hashMap.put("diseaseCategory", diseaseCategory);
        hashMap.put("diseaseHandlingSituation", diseaseHandlingSituation);
        hashMap.put("subject", subjectMap);
        hashMap.put("diseasePosition", diseasePosition);
        return hashMap;
    }

    @Override
    public Map<String, Object> countMaintenance(Map<String, Object> map) {
        Map<String, Object> resultMap = new HashMap<>();
        //各个类别的金额统计
        QueryWrapper<BizCourseDetails> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("PCODE_", "CBKM");
        queryWrapper.eq("IS_DELE_", "0");
        //查询出所有的类别CODE
        List<BizCourseDetails> listPcode = bizCourseDetailsManager.list(queryWrapper);
        //查询根据查询出的类别code查询出细目类别CODE
        List<BizCourseDetails> subjectCodes = bizCourseDetailsManager.list(new QueryWrapper<BizCourseDetails>().in("PCODE_", listPcode.stream().map(BizCourseDetails::getSubjectCode).collect(Collectors.toList())));
        ArrayList<MaintenanceEveryMoneyVo> courseDetails = new ArrayList<>();
        List<MaintenanceEveryMoneyVo> mapList = this.statisticalStatementDao.countMaintenanceEveryMoney(map);
        subjectCodes.forEach(s -> {
            MaintenanceEveryMoneyVo maintenanceEveryMoneyVo = new MaintenanceEveryMoneyVo();
            maintenanceEveryMoneyVo.setPcode(s.getPcode());
            maintenanceEveryMoneyVo.setPname(s.getPname());
            maintenanceEveryMoneyVo.setSubjectCode(s.getSubjectCode());
            maintenanceEveryMoneyVo.setSubjectName(s.getSubjectName());
            courseDetails.add(maintenanceEveryMoneyVo);
        });
        courseDetails.forEach(s -> {
            mapList.forEach(x -> {
                if (s.getPcode().equals(x.getPcode()) && s.getSubjectCode().equals(x.getSubjectCode())) {
                    s.setEveryMoney(x.getEveryMoney());
                }
            });
        });
        List<MaintenanceYearMoney> maintenanceYearMonies = this.statisticalStatementDao.countMaintenanceYearMoney(map);
        //各路段养护金额
        QueryWrapper<Road> queryWrapperRoad = new QueryWrapper<>();
        queryWrapperRoad.eq("IS_DELE_", "0");
        queryWrapperRoad.eq(ObjectUtils.isNotEmpty(map.get("roadSegmentId")), "id_", map.get("roadSegmentId"));
        List<Road> listRoad = roadManager.list(queryWrapperRoad);
        List<MaintenanceRoadMoneyVo> maintenanceRoadMoneyVos = this.statisticalStatementDao.countMaintenanceRoadMoney(map);
        ArrayList<MaintenanceRoadMoneyVo> moneyVos = new ArrayList<>();
        listRoad.forEach(s -> {
            MaintenanceRoadMoneyVo maintenanceRoadMoneyVo = new MaintenanceRoadMoneyVo();
            maintenanceRoadMoneyVo.setRoadSegmentId(s.getId());
            maintenanceRoadMoneyVo.setRoadSegmentName(s.getName());
            moneyVos.add(maintenanceRoadMoneyVo);
        });
        moneyVos.forEach(s -> {
            maintenanceRoadMoneyVos.forEach(x -> {
                if (s.getRoadSegmentId().equals(x.getRoadSegmentId())) {
                    s.setTotalMoney(x.getTotalMoney());
                }
            });
        });
        //各类别金额统计
        resultMap.put("courseDetails", courseDetails);
        //各个年份金额统计
        resultMap.put("maintenanceYearMonies", maintenanceYearMonies);
        //各个路段养护金额
        resultMap.put("MaintenanceRoadMoney", moneyVos);
        return resultMap;
    }

    @Override
    public Map<String, Object> countSiteDaily(Map<String, Object> map) {
        QueryWrapper<SiteInspection> siteInspectionQueryWrapper = new QueryWrapper<>();
        siteInspectionQueryWrapper.eq("IS_DELE_", 0);
        siteInspectionQueryWrapper.ge(ObjectUtils.isNotEmpty(map.get("startTime")), "PATROL_DATE_", map.get("startTime"));
        siteInspectionQueryWrapper.le(ObjectUtils.isNotEmpty(map.get("endTime")), "PATROL_DATE_", map.get("endTime"));

        if(null != map.get("roadSegmentId")){
            List<String> roadSegmentIds = Arrays.asList(map.get("roadSegmentId").toString().split(","));
            siteInspectionQueryWrapper.in( "ROAD_SEGMENT_ID_",roadSegmentIds);

        }


        List<SiteInspection> siteInspectionList = siteInspectionManager.list(siteInspectionQueryWrapper);
        //应巡检
        int countSiteDailyFinish=0 ;
        int countSiteDailyUnFinish =0;
        for (SiteInspection s : siteInspectionList) {
            if( null != s.getType() && null != s.getHandStatus() && s.getType() == 1 && "1".equals(s.getHandStatus())){
                countSiteDailyFinish++;
            }
            if(null != s.getType() &&s.getType() == 1 ){
                countSiteDailyUnFinish++;
            }
        }
        List<Circle> circles = new ArrayList<>();
        Circle circle = new Circle();
        circle.setName("应巡检");
        circle.setValue(String.valueOf(countSiteDailyFinish));
        circles.add(circle);
        Circle cir = new Circle();
        cir.setName("实际巡检");
        cir.setValue(String.valueOf(countSiteDailyUnFinish));
        circles.add(cir);
        //柱形图
        List<InspectForRoadSegment> inspectForRoadSegments = new ArrayList<>();
        List<InspectForRoadSegment> inspectForRoadSegmentList = this.statisticalStatementDao.countSiteDaily(map);


        QueryWrapper<Road> queryWrapperRoad = new QueryWrapper<>();
        queryWrapperRoad.eq("IS_DELE_", "0");

        if(null != map.get("roadSegmentId")){
            List<String> roadSegmentIds = Arrays.asList(map.get("roadSegmentId").toString().split(","));
            queryWrapperRoad.in( "id_", roadSegmentIds);
        }
        List<Road> listRoad = roadManager.list(queryWrapperRoad);

        listRoad.forEach(s -> {
            InspectForRoadSegment inspectForRoadSegment = new InspectForRoadSegment();
            inspectForRoadSegment.setRoadSegmentId(s.getId());
            inspectForRoadSegment.setRoadSegmentName(s.getName());
            inspectForRoadSegments.add(inspectForRoadSegment);
        });

        inspectForRoadSegments.forEach(s -> {
            inspectForRoadSegmentList.forEach(x -> {
                if (s.getRoadSegmentId().equals(x.getRoadSegmentId())) {
                    s.setValueFinish(x.getValueFinish());
                    s.setValueUnFinish(x.getValueUnFinish());
                }
            });
        });
        HashMap<String, Object> hashMap = new HashMap<>();
        hashMap.put("circles", circles);
        hashMap.put("inspectForRoadSegments", inspectForRoadSegments);
        return hashMap;
    }

    @Override
    public Map<String, Object> countSiteNight(Map<String, Object> map) {
        QueryWrapper<SiteInspection> siteInspectionQueryWrapper = new QueryWrapper<>();
        siteInspectionQueryWrapper.eq("IS_DELE_", 0);
        siteInspectionQueryWrapper.ge(ObjectUtils.isNotEmpty(map.get("startTime")), "PATROL_DATE_", map.get("startTime"));
        siteInspectionQueryWrapper.le(ObjectUtils.isNotEmpty(map.get("endTime")), "PATROL_DATE_", map.get("endTime"));
        siteInspectionQueryWrapper.in(ObjectUtils.isNotEmpty(map.get("roadSegmentId")), "ROAD_SEGMENT_ID_",Arrays.asList(map.get("roadSegmentId").toString().split(",")));
        List<SiteInspection> siteInspectionList = siteInspectionManager.list(siteInspectionQueryWrapper);
        //应巡检
        long countSiteDailyFinish = siteInspectionList.stream().filter(s -> s.getType() == 2).filter(s -> "1".equals(s.getHandStatus())).count();
        //实际巡检
        long countSiteDailyUnFinish = siteInspectionList.stream().filter(s -> s.getType() == 2).count();
        List<Circle> circles = new ArrayList<>();
        Circle circle = new Circle();
        circle.setName("应巡检");
        circle.setValue(String.valueOf(countSiteDailyFinish));
        circles.add(circle);
        Circle cir = new Circle();
        cir.setName("实际巡检");
        cir.setValue(String.valueOf(countSiteDailyUnFinish));
        circles.add(cir);
        //柱形图
        List<InspectForRoadSegment> inspectForRoadSegments = new ArrayList<>();
        List<InspectForRoadSegment> inspectForRoadSegmentList = this.statisticalStatementDao.countSiteNight(map);


        QueryWrapper<Road> queryWrapperRoad = new QueryWrapper<>();
        queryWrapperRoad.eq("IS_DELE_", "0");
        queryWrapperRoad.in(ObjectUtils.isNotEmpty(map.get("roadSegmentId")), "id_", Arrays.asList(map.get("roadSegmentId").toString().split(",")));
        List<Road> listRoad = roadManager.list(queryWrapperRoad);

        listRoad.forEach(s -> {
            InspectForRoadSegment inspectForRoadSegment = new InspectForRoadSegment();
            inspectForRoadSegment.setRoadSegmentId(s.getId());
            inspectForRoadSegment.setRoadSegmentName(s.getName());
            inspectForRoadSegments.add(inspectForRoadSegment);
        });

        inspectForRoadSegments.forEach(s -> {
            inspectForRoadSegmentList.forEach(x -> {
                if (s.getRoadSegmentId().equals(x.getRoadSegmentId())) {
                    s.setValueFinish(x.getValueFinish());
                    s.setValueUnFinish(x.getValueUnFinish());
                }
            });
        });
        HashMap<String, Object> hashMap = new HashMap<>();
        hashMap.put("circles", circles);
        hashMap.put("inspectForRoadSegments", inspectForRoadSegments);
        return hashMap;
    }

    @Override
    public Map<String, Object> countBridgeCheck(Map<String, Object> map) {
        //圆形
        List<Circle> circles = new ArrayList<>();
        //柱形图
        List<InspectForRoadSegment> inspectForRoadSegments = new ArrayList<>();
        QueryWrapper<Road> roadQueryWrapper = new QueryWrapper<>();
        roadQueryWrapper.in(ObjectUtils.isNotEmpty(map.get("roadSegmentId")), "id_", Arrays.asList(map.get("roadSegmentId").toString().split(",")));
        List<Road> roadList = roadManager.list(roadQueryWrapper);
        roadList.forEach(s -> {
            InspectForRoadSegment inspectForRoadSegment = new InspectForRoadSegment();
            inspectForRoadSegment.setRoadSegmentId(s.getId());
            inspectForRoadSegment.setRoadSegmentName(s.getName());
            inspectForRoadSegments.add(inspectForRoadSegment);
        });
        String roadIds = roadList.stream().map(Road::getId).collect(Collectors.joining(","));
        QueryWrapper<BridgeInformation> bridgeQueryWrapper = new QueryWrapper<>();
        bridgeQueryWrapper.eq("IS_DELE_", "0");
        bridgeQueryWrapper.in(roadList.size() > 0, "ROAD_SEGMENT_ID_", Arrays.asList(roadIds.split(",")));
        List<BridgeInformation> list = bridgeInformationManager.list(bridgeQueryWrapper);
        //年
        Object accDateYear = map.get("accDateYear");
        //月份
        Object accDateMonth = map.get("accDateMonth");
        //应巡检次数
        if (ObjectUtils.isEmpty(accDateYear)) {
            throw new RuntimeException("请选择年份");
        }
        if (ObjectUtils.isEmpty(accDateMonth)) {
            Circle circle = new Circle();
            circle.setName("应巡检");
            circle.setValue(String.valueOf(12 * list.size()));
            //实际巡检
            Circle circle2 = new Circle();
            circle2.setName("实际巡检");
            List<String> bridgeId = list.stream().map(BridgeInformation::getId).collect(Collectors.toList());
            Integer integer = statisticalStatementDao.countBridgeCheckYear(map, bridgeId);
            circle2.setValue(String.valueOf(integer));
            circles.add(circle);
            circles.add(circle2);
            Map<String, List<BridgeInformation>> collect = list.stream().collect(Collectors.groupingBy(BridgeInformation::getRoadSegmentId));
            for (Map.Entry<String, List<BridgeInformation>> entry : collect.entrySet()) {
                for (InspectForRoadSegment inspectForRoadSegment : inspectForRoadSegments) {
                    if (entry.getKey().equals(inspectForRoadSegment.getRoadSegmentId())) {
                        List<BridgeInformation> bridgeInformationList = entry.getValue();
                        List<String> bridgeGroupId = bridgeInformationList.stream().map(BridgeInformation::getId).collect(Collectors.toList());
                        Integer valueUnFinishInteger = statisticalStatementDao.countBridgeCheckYear(map, bridgeGroupId);
                        inspectForRoadSegment.setValueFinish(String.valueOf(valueUnFinishInteger));
                        inspectForRoadSegment.setValueUnFinish(String.valueOf(12 * bridgeInformationList.size()));
                    }
                }
            }

        } else {
            Circle circle = new Circle();
            circle.setName("应巡检");
            circle.setValue(String.valueOf(list.size()));
            //实际巡检
            Circle circle2 = new Circle();
            circle2.setName("实际巡检");
            List<String> bridgeId = list.stream().map(BridgeInformation::getId).collect(Collectors.toList());
            Integer integer = statisticalStatementDao.countBridgeCheckMouth(map, bridgeId);
            circle2.setValue(String.valueOf(integer));
            circles.add(circle);
            circles.add(circle2);
            Map<String, List<BridgeInformation>> collect = list.stream().collect(Collectors.groupingBy(BridgeInformation::getRoadSegmentId));
            for (Map.Entry<String, List<BridgeInformation>> entry : collect.entrySet()) {
                for (InspectForRoadSegment inspectForRoadSegment : inspectForRoadSegments) {
                    if (entry.getKey().equals(inspectForRoadSegment.getRoadSegmentId())) {
                        List<BridgeInformation> bridgeInformationList = entry.getValue();
                        List<String> bridgeGroupId = bridgeInformationList.stream().map(BridgeInformation::getId).collect(Collectors.toList());
                        Integer valueUnFinishInteger = statisticalStatementDao.countBridgeCheckMouth(map, bridgeGroupId);
                        inspectForRoadSegment.setValueFinish(String.valueOf(valueUnFinishInteger));
                        inspectForRoadSegment.setValueUnFinish(String.valueOf(12 * bridgeInformationList.size()));

                    }
                }

            }
        }

        HashMap<String, Object> hashMap = new HashMap<>();
        hashMap.put("circles", circles);
        hashMap.put("inspectForRoadSegments", inspectForRoadSegments);
        return hashMap;
    }


    @Override
    public Map<String, Object> countReportBridge(Map<String, Object> map) {
        if (ObjectUtils.isNotEmpty(map.get("roadSegmentId"))){
            List<String> ids = Arrays.asList(map.get("roadSegmentId").toString().split(","));
            map.put("ids",ids);
        }
        List<Map<String, Object>> bridgeType = this.statisticalStatementDao.countBridgeType(map);
        List<Map<String, Object>> bridgeShapeType = this.statisticalStatementDao.countBridgeShapeType(map);

        List<Map<String, Object>> bridgeCategory = this.statisticalStatementDao.countBridgeCategory(map);
        Map<String, Object> hashMap = new HashMap<>();
        hashMap.put("bridgeType", bridgeType);
        hashMap.put("bridgeShapeType", bridgeShapeType);
        hashMap.put("category", bridgeCategory);
        return hashMap;
    }

    @Override
    public HSSFWorkbook exportBridge(HttpServletResponse response, Map<String, Object> map) {
        try {
            List<Map<String, Object>> bridgeCategory = this.statisticalStatementDao.countBridgeCategory(map);
            Map<String, String> exportMap = new LinkedHashMap<>();
            exportMap.put("shapeTypeValue", "上部结构名称");
            exportMap.put("shapeTypeCount", "数量");
            exportMap.put("length", "单位总长(m)");
            List<HashMap<String, Object>> collect = bridgeCategory.stream().map(s -> {
                HashMap<String, Object> hashMap = new HashMap<>();
                hashMap.put("shapeTypeValue", s.get("categoryValue"));
                hashMap.put("shapeTypeCount", s.get("categoryCount"));
                hashMap.put("length", s.get("length"));
                return hashMap;
            }).collect(Collectors.toList());
            return ExcelUtil.exportExcel("桥梁结构", 10, exportMap, collect);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出失败");
        }
    }

    @Override
    public List<MaintainMessageVo> maintainMessage(Map<String, Object> map) {

        ArrayList<MaintainMessageVo> maintainMessageVos = new ArrayList<>();
        BigDecimal decimalAll = new BigDecimal(2);
        QueryWrapper<Road> roadQueryWrapper = new QueryWrapper<>();
        roadQueryWrapper.in(ObjectUtils.isNotEmpty(map.get("roadSegmentId")), "ID_", Arrays.asList(map.get("roadSegmentId").toString().split(",")));
        roadQueryWrapper.like(StringUtils.isNotEmpty(baseContext.getCurrentOrgId()), "COMPANY_IDS_", baseContext.getCurrentOrgId());
        List<Road> roadList = roadManager.list(roadQueryWrapper);
        roadList.forEach(s -> {
            MaintainMessageVo messageVo = new MaintainMessageVo();
            Org org = this.getPrentId(s.getCompanyId());
            if (org != null) {
                messageVo.setOrgId(org.getId());
                messageVo.setOrgName(org.getName());
            }
            messageVo.setId(UUID.randomUUID().toString());
            messageVo.setCompanyId(s.getCompanyId());
            messageVo.setCompanyName(s.getCompanyName());
            messageVo.setRoadSegmentId(s.getId());
            messageVo.setRoadSegmentName(s.getName());
            if (s.getLength() != null) {
                messageVo.setRoadLength(new BigDecimal(s.getLength()).setScale(2, BigDecimal.ROUND_HALF_UP));
            }
            if (s.getWidth() != null) {
                messageVo.setRoadWidth(new BigDecimal(s.getWidth()));
            }
            messageVo.setStartPegK(s.getStartPegK());
            messageVo.setEndPegK(s.getEndPegK());
            maintainMessageVos.add(messageVo);
        });
        //桥梁
        QueryWrapper<BridgeInformation> bridgeQueryWrapper = new QueryWrapper<>();
        bridgeQueryWrapper.in(roadList != null && roadList.size() > 0, "ROAD_SEGMENT_ID_", roadList.stream().map(Road::getId).collect(Collectors.toList()));
        List<BridgeInformation> bridgeInformationList = bridgeInformationManager.list(bridgeQueryWrapper);
        Map<String, List<BridgeInformation>> collectBridge = bridgeInformationList.stream().collect(Collectors.groupingBy(BridgeInformation::getRoadSegmentId));
        for (Map.Entry<String, List<BridgeInformation>> entry : collectBridge.entrySet()) {
            for (MaintainMessageVo maintainMessageVo : maintainMessageVos) {
                if (maintainMessageVo.getRoadSegmentId().equals(entry.getKey())) {
                    List<BridgeInformation> bridgeList = collectBridge.get(entry.getKey());
                    //所有大桥
                    maintainMessageVo.setBridgeCount(bridgeList.size());
                    double bridgeSum = bridgeList.stream().mapToDouble(BridgeInformation::getLength).sum();
                    BigDecimal bridgeDecimal = new BigDecimal(bridgeSum);
                    BigDecimal bridgeLinearMeter = bridgeDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
                    BigDecimal bridgeSingleCount = bridgeLinearMeter.divide(decimalAll);
                    maintainMessageVo.setBridgeLinearMeter(bridgeLinearMeter);
                    maintainMessageVo.setBridgeSingleCount(bridgeSingleCount);
                    //特大桥
                    long extraBigBridgeCount = bridgeList.stream().filter(s -> "1".equals(s.getType())).count();
                    double extraBigBridgeLinearMeterSum = bridgeList.stream().filter(s -> "1".equals(s.getType())).mapToDouble(BridgeInformation::getLength).sum();
                    BigDecimal extraBigBridgeLinearMeterBigDecimal = new BigDecimal(extraBigBridgeLinearMeterSum);
                    BigDecimal extraBigBridgeLinearMeter = extraBigBridgeLinearMeterBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
                    BigDecimal extraBigBridgeSingleCount = extraBigBridgeLinearMeter.divide(decimalAll);
                    maintainMessageVo.setExtraBigBridgeCount(Integer.parseInt(String.valueOf(extraBigBridgeCount)));
                    maintainMessageVo.setExtraBigBridgeLinearMeter(extraBigBridgeLinearMeter);
                    maintainMessageVo.setExtraBigBridgeSingleCount(extraBigBridgeSingleCount);
                    //大桥 bigBridgeCount
                    long bigBridgeCount = bridgeList.stream().filter(s -> "2".equals(s.getType())).count();

                    double bigSum = bridgeList.stream().filter(s -> "2".equals(s.getType())).mapToDouble(BridgeInformation::getLength).sum();
                    BigDecimal decimal = new BigDecimal(bigSum);
                    //大桥桥梁延米总长
                    BigDecimal bigBridgeLinearMeter = decimal.setScale(2, BigDecimal.ROUND_HALF_UP);
                    //大桥桥梁单幅总长
                    BigDecimal bigBridgeSingleCount = bigBridgeLinearMeter.divide(decimalAll);
                    maintainMessageVo.setBigBridgeCount(Integer.parseInt(String.valueOf(bigBridgeCount)));
                    maintainMessageVo.setBigBridgeSingleCount(bigBridgeSingleCount);
                    maintainMessageVo.setBigBridgeLinearMeter(bigBridgeLinearMeter);
                    //中桥 middleBridgeCount
                    long middleBridgeCount = bridgeList.stream().filter(s -> "3".equals(s.getType())).count();
                    double middleSum = bridgeList.stream().filter(s -> "3".equals(s.getType())).mapToDouble(BridgeInformation::getLength).sum();
                    BigDecimal middleSumDecimal = new BigDecimal(middleSum);
                    //中桥桥梁延米总长
                    BigDecimal middleBridgeLinearMeter = middleSumDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
                    BigDecimal middleBridgeSingleCount = middleBridgeLinearMeter.divide(decimalAll);
                    maintainMessageVo.setMiddleBridgeCount(Integer.parseInt(String.valueOf(middleBridgeCount)));
                    maintainMessageVo.setMiddleBridgeLinearMeter(middleBridgeLinearMeter);
                    maintainMessageVo.setMiddleBridgeSingleCount(middleBridgeSingleCount);
                    //小桥 smallBridgeCount
                    long smallBridgeCount = bridgeList.stream().filter(s -> "4".equals(s.getType())).count();
                    double smallBridgeSum = bridgeList.stream().filter(s -> "4".equals(s.getType())).mapToDouble(BridgeInformation::getLength).sum();
                    BigDecimal smallBridgeBigDecimal = new BigDecimal(smallBridgeSum);
                    BigDecimal smallBridgeLinearMeter = smallBridgeBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
                    BigDecimal smallBridgeSingleCount = smallBridgeLinearMeter.divide(decimalAll);
                    maintainMessageVo.setSmallBridgeCount(Integer.parseInt(String.valueOf(smallBridgeCount)));
                    maintainMessageVo.setSmallBridgeLinearMeter(smallBridgeLinearMeter);
                    maintainMessageVo.setSmallBridgeSingleCount(smallBridgeSingleCount);
                }
            }

        }
        //隧道
        QueryWrapper<TunnelInformation> tunnelQueryWrapper = new QueryWrapper<>();
        tunnelQueryWrapper.in(roadList != null && roadList.size() > 0, "ROAD_SEGMENT_ID_", roadList.stream().map(Road::getId).collect(Collectors.toList()));
        List<TunnelInformation> tunnelInformationList = tunnelInformationManager.list(tunnelQueryWrapper);
        Map<String, List<TunnelInformation>> collectTunnel = tunnelInformationList.stream().collect(Collectors.groupingBy(TunnelInformation::getRoadSegmentId));


        for (Map.Entry<String, List<TunnelInformation>> entry : collectTunnel.entrySet()) {
            for (MaintainMessageVo maintainMessageVo : maintainMessageVos) {
                if (maintainMessageVo.getRoadSegmentId().equals(entry.getKey())) {
                    List<TunnelInformation> tunnelList = collectTunnel.get(entry.getKey());
                    maintainMessageVo.setTunnelCount(Integer.parseInt(String.valueOf(tunnelList.size())));
                    double tunnelSum = tunnelList.stream().mapToDouble(TunnelInformation::getLength).sum();
                    BigDecimal tunnelBigDecimal = new BigDecimal(tunnelSum);
                    BigDecimal tunnelLinearMeter = tunnelBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
                    BigDecimal tunnelSingleCount = tunnelLinearMeter.divide(decimalAll);
                    maintainMessageVo.setTunnelSingleCount(tunnelSingleCount);
                    maintainMessageVo.setTunnelLinearMeter(tunnelLinearMeter);
                    //特长
                    long extraBigTunnelCount = tunnelList.stream().filter(s -> "1".equals(s.getType())).count();
                    double extraBigSum = tunnelList.stream().filter(s -> "1".equals(s.getType())).mapToDouble(TunnelInformation::getLength).sum();
                    BigDecimal extraBigBigDecimal = new BigDecimal(extraBigSum);
                    BigDecimal extraBigTunnelLinearMeter = extraBigBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
                    BigDecimal extraBigTunnelSingleCount = extraBigTunnelLinearMeter.divide(decimalAll);
                    maintainMessageVo.setExtraBigTunnelCount(Integer.parseInt(String.valueOf(extraBigTunnelCount)));
                    maintainMessageVo.setExtraBigTunnelSingleCount(extraBigTunnelSingleCount);
                    maintainMessageVo.setExtraBigTunnelLinearMeter(extraBigTunnelLinearMeter);
                    //长
                    long bigTunnelCount = tunnelList.stream().filter(s -> "2".equals(s.getType())).count();
                    double bigTunnelSum = tunnelList.stream().filter(s -> "2".equals(s.getType())).mapToDouble(TunnelInformation::getLength).sum();
                    BigDecimal bigTunnelBigDecimal = new BigDecimal(bigTunnelSum);
                    BigDecimal bigTunnelLinearMeter = bigTunnelBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
                    BigDecimal bigTunnelSingleCount = bigTunnelLinearMeter.divide(decimalAll);
                    maintainMessageVo.setBigTunnelCount(Integer.parseInt(String.valueOf(bigTunnelCount)));
                    maintainMessageVo.setBigTunnelSingleCount(bigTunnelSingleCount);
                    maintainMessageVo.setBigTunnelLinearMeter(bigTunnelLinearMeter);
                    //中
                    long middleTunnelCount = tunnelList.stream().filter(s -> "3".equals(s.getType())).count();
                    double middleTunnelSum = tunnelList.stream().filter(s -> "3".equals(s.getType())).mapToDouble(TunnelInformation::getLength).sum();
                    BigDecimal middleTunnelBigDecimal = new BigDecimal(middleTunnelSum);
                    BigDecimal middleTunnelLinearMeter = middleTunnelBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
                    BigDecimal middleTunnelSingleCount = middleTunnelLinearMeter.divide(decimalAll);
                    maintainMessageVo.setMiddleTunnelCount(Integer.parseInt(String.valueOf(middleTunnelCount)));
                    maintainMessageVo.setMiddleTunnelSingleCount(middleTunnelSingleCount);
                    maintainMessageVo.setMiddleTunnelLinearMeter(middleTunnelLinearMeter);
                    //短
                    long smallTunnelCount = tunnelList.stream().filter(s -> "4".equals(s.getType())).count();
                    double smallTunnelCountSum = tunnelList.stream().filter(s -> "4".equals(s.getType())).mapToDouble(TunnelInformation::getLength).sum();
                    BigDecimal smallTunnelCountBigDecimal = new BigDecimal(smallTunnelCountSum);
                    BigDecimal smallTunnelCountLinearMeter = smallTunnelCountBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
                    BigDecimal smallTunnelCountSingleCount = smallTunnelCountLinearMeter.divide(decimalAll);
                    maintainMessageVo.setSmallTunnelCount(Integer.parseInt(String.valueOf(smallTunnelCount)));
                    maintainMessageVo.setSmallTunnelSingleCount(smallTunnelCountSingleCount);
                    maintainMessageVo.setSmallTunnelLinearMeter(smallTunnelCountLinearMeter);
                }
            }
        }

        //涵洞数量
        QueryWrapper<BizCulvertInformation> culvertQueryWrapper = new QueryWrapper<>();
        culvertQueryWrapper.in(roadList != null && roadList.size() > 0, "ROAD_SEGMENT_ID_", roadList.stream().map(Road::getId).collect(Collectors.toList()));
        List<BizCulvertInformation> culvertInformationList = culvertInformationManager.list(culvertQueryWrapper);
        Map<String, List<BizCulvertInformation>> culvertCollect = culvertInformationList.stream().collect(Collectors.groupingBy(BizCulvertInformation::getRoadSegmentId));
        for (Map.Entry<String, List<BizCulvertInformation>> entry : culvertCollect.entrySet()) {
            for (MaintainMessageVo maintainMessageVo : maintainMessageVos) {
                if (maintainMessageVo.getRoadSegmentId().equals(entry.getKey())) {
                    List<BizCulvertInformation> culvertList = culvertCollect.get(entry.getKey());
                    maintainMessageVo.setCulvertCount(Integer.parseInt(String.valueOf(culvertList.size())));
                }
            }
        }
        //边坡数量
        QueryWrapper<SideSlopeInformation> sideSlopeQueryWrapper = new QueryWrapper<>();
        sideSlopeQueryWrapper.in(roadList != null && roadList.size() > 0, "ROAD_SEGMENT_ID_", roadList.stream().map(Road::getId).collect(Collectors.toList()));
        List<SideSlopeInformation> slopeInformationList = sideSlopeInformationManager.list(sideSlopeQueryWrapper);
        Map<String, List<SideSlopeInformation>> slopeCollect = slopeInformationList.stream().collect(Collectors.groupingBy(SideSlopeInformation::getRoadSegmentId));
        for (Map.Entry<String, List<SideSlopeInformation>> entry : slopeCollect.entrySet()) {
            for (MaintainMessageVo maintainMessageVo : maintainMessageVos) {
                if (maintainMessageVo.getRoadSegmentId().equals(entry.getKey())) {
                    List<SideSlopeInformation> sideSlopeList = slopeCollect.get(entry.getKey());
                    maintainMessageVo.setSideSlopeCount(Integer.parseInt(String.valueOf(sideSlopeList.size())));
                }
            }
        }
        Map<String, List<MaintainMessageVo>> maintainMessageMap = maintainMessageVos.stream().collect(Collectors.groupingBy(MaintainMessageVo::getCompanyId));
        for (Map.Entry<String, List<MaintainMessageVo>> entry : maintainMessageMap.entrySet()) {
            List<MaintainMessageVo> messageVos = maintainMessageMap.get(entry.getKey());
            MaintainMessageVo maintainMessageVo = new MaintainMessageVo();
            MaintainMessageVo vo = messageVos.get(0);
            maintainMessageVo.setId(UUID.randomUUID().toString());
            maintainMessageVo.setOrgId(vo.getOrgId());
            maintainMessageVo.setOrgName(vo.getOrgName());
            maintainMessageVo.setCompanyId(entry.getKey());
            maintainMessageVo.setCompanyName(vo.getCompanyName());
            maintainMessageVo.setRoadSegmentName("小计");
            //路段长度
            maintainMessageVo.setRoadLength(messageVos.stream().map(MaintainMessageVo::getRoadLength).reduce(BigDecimal.ZERO, BigDecimal::add));
            //路段宽度
            maintainMessageVo.setRoadWidth(messageVos.stream().map(MaintainMessageVo::getRoadWidth).reduce(BigDecimal.ZERO, BigDecimal::add));
            //桥梁数量
            maintainMessageVo.setBridgeCount(messageVos.stream().mapToInt(MaintainMessageVo::getBridgeCount).sum());
            //桥梁单幅总长
            maintainMessageVo.setBridgeSingleCount(messageVos.stream().map(MaintainMessageVo::getBridgeSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            //桥梁延米总长
            maintainMessageVo.setBridgeLinearMeter(messageVos.stream().map(MaintainMessageVo::getBridgeLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            //特大桥数量
            maintainMessageVo.setExtraBigBridgeCount(messageVos.stream().mapToInt(MaintainMessageVo::getExtraBigBridgeCount).sum());
            //特大桥桥梁单幅总长
            maintainMessageVo.setExtraBigBridgeSingleCount(messageVos.stream().map(MaintainMessageVo::getExtraBigBridgeSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            //特大桥桥梁延米总长
            maintainMessageVo.setExtraBigBridgeLinearMeter(messageVos.stream().map(MaintainMessageVo::getExtraBigBridgeLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            //大桥数量
            maintainMessageVo.setBigBridgeCount(messageVos.stream().mapToInt(MaintainMessageVo::getBigBridgeCount).sum());
            //大桥桥梁单幅总长
            maintainMessageVo.setBigBridgeSingleCount(messageVos.stream().map(MaintainMessageVo::getBigBridgeSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            //大桥桥梁延米总长
            maintainMessageVo.setBigBridgeLinearMeter(messageVos.stream().map(MaintainMessageVo::getBigBridgeLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            //中桥数量
            maintainMessageVo.setMiddleBridgeCount(messageVos.stream().mapToInt(MaintainMessageVo::getMiddleBridgeCount).sum());
            //中桥桥梁单幅总长
            maintainMessageVo.setMiddleBridgeSingleCount(messageVos.stream().map(MaintainMessageVo::getMiddleBridgeSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            //中桥桥梁延米总长
            maintainMessageVo.setMiddleBridgeLinearMeter(messageVos.stream().map(MaintainMessageVo::getMiddleBridgeLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            //小桥数量
            maintainMessageVo.setSmallBridgeCount(messageVos.stream().mapToInt(MaintainMessageVo::getSmallBridgeCount).sum());
            //小桥桥梁单幅总长
            maintainMessageVo.setSmallBridgeSingleCount(messageVos.stream().map(MaintainMessageVo::getSmallBridgeSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            //小桥桥梁延米总长
            maintainMessageVo.setSmallBridgeLinearMeter(messageVos.stream().map(MaintainMessageVo::getSmallBridgeLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            //隧道数量
            maintainMessageVo.setTunnelCount(messageVos.stream().mapToInt(MaintainMessageVo::getTunnelCount).sum());
            //隧道单洞总长
            maintainMessageVo.setTunnelSingleCount(messageVos.stream().map(MaintainMessageVo::getTunnelSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            //隧道单洞延米总长
            maintainMessageVo.setTunnelLinearMeter(messageVos.stream().map(MaintainMessageVo::getTunnelLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            //特长隧道数量
            maintainMessageVo.setExtraBigTunnelCount(messageVos.stream().mapToInt(MaintainMessageVo::getExtraBigTunnelCount).sum());
            //特长隧道单洞总长
            maintainMessageVo.setExtraBigTunnelSingleCount(messageVos.stream().map(MaintainMessageVo::getExtraBigTunnelSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            //特长隧道延米总长
            maintainMessageVo.setExtraBigTunnelLinearMeter(messageVos.stream().map(MaintainMessageVo::getExtraBigTunnelLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            //长隧道数量
            maintainMessageVo.setBigTunnelCount(messageVos.stream().mapToInt(MaintainMessageVo::getBigTunnelCount).sum());
            //长隧道单洞总长
            maintainMessageVo.setBigTunnelSingleCount(messageVos.stream().map(MaintainMessageVo::getBigTunnelSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            //长隧道单洞延米总长
            maintainMessageVo.setBigTunnelLinearMeter(messageVos.stream().map(MaintainMessageVo::getBigTunnelLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            //中隧道数量
            maintainMessageVo.setMiddleTunnelCount(messageVos.stream().mapToInt(MaintainMessageVo::getMiddleTunnelCount).sum());
            //中隧道单洞总长
            maintainMessageVo.setMiddleTunnelSingleCount(messageVos.stream().map(MaintainMessageVo::getMiddleTunnelSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            //中隧道延米总长
            maintainMessageVo.setMiddleTunnelLinearMeter(messageVos.stream().map(MaintainMessageVo::getMiddleTunnelLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            //短隧道数量
            maintainMessageVo.setSmallTunnelCount(messageVos.stream().mapToInt(MaintainMessageVo::getSmallTunnelCount).sum());
            //短隧道单洞总长
            maintainMessageVo.setSmallTunnelSingleCount(messageVos.stream().map(MaintainMessageVo::getSmallTunnelSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            //短隧道单洞延米总长
            maintainMessageVo.setSmallTunnelLinearMeter(messageVos.stream().map(MaintainMessageVo::getSmallTunnelLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            //涵洞数量
            maintainMessageVo.setCulvertCount(messageVos.stream().mapToInt(MaintainMessageVo::getCulvertCount).sum());
            //边坡
            maintainMessageVo.setSideSlopeCount(messageVos.stream().mapToInt(MaintainMessageVo::getSideSlopeCount).sum());
            maintainMessageVos.add(maintainMessageVo);
        }

        return maintainMessageVos.stream().sorted(Comparator.comparing(MaintainMessageVo::getOrgName)).sorted(Comparator.comparing(MaintainMessageVo::getCompanyName)).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> countTunnelCheck(Map<String, Object> map) {
        //圆形
        List<Circle> circles = new ArrayList<>();
        //柱形图
        List<InspectForRoadSegment> inspectForRoadSegments = new ArrayList<>();
        QueryWrapper<Road> roadQueryWrapper = new QueryWrapper<>();
        roadQueryWrapper.in(ObjectUtils.isNotEmpty(map.get("roadSegmentId")), "id_", Arrays.asList(map.get("roadSegmentId").toString().split(",")));
        List<Road> roadList = roadManager.list(roadQueryWrapper);
        roadList.forEach(s -> {
            InspectForRoadSegment inspectForRoadSegment = new InspectForRoadSegment();
            inspectForRoadSegment.setRoadSegmentId(s.getId());
            inspectForRoadSegment.setRoadSegmentName(s.getName());
            inspectForRoadSegments.add(inspectForRoadSegment);
        });
        String roadIds = roadList.stream().map(Road::getId).collect(Collectors.joining(","));
        QueryWrapper<TunnelInformation> tunnelQueryWrapper = new QueryWrapper<>();
        tunnelQueryWrapper.eq("IS_DELE_", "0");
        tunnelQueryWrapper.in(roadList.size() > 0, "ROAD_SEGMENT_ID_", Arrays.asList(roadIds.split(",")));
        List<TunnelInformation> list = tunnelInformationManager.list(tunnelQueryWrapper);
        //年
        Object accDateYear = map.get("accDateYear");
        //月份
        Object accDateMonth = map.get("accDateMonth");
        //应巡检次数
        if (ObjectUtils.isEmpty(accDateYear)) {
            throw new RuntimeException("请选择年份");
        }
        if (ObjectUtils.isEmpty(accDateMonth)) {
            Circle circle = new Circle();
            circle.setName("应巡检");
            circle.setValue(String.valueOf(12 * list.size()));
            //实际巡检
            Circle circle2 = new Circle();
            circle2.setName("实际巡检");
            List<String> tunnelId = list.stream().map(TunnelInformation::getId).collect(Collectors.toList());
            Integer integer = statisticalStatementDao.countTunnelCheckYear(map, tunnelId);
            circle2.setValue(String.valueOf(integer));
            circles.add(circle);
            circles.add(circle2);
            Map<String, List<TunnelInformation>> collect = list.stream().collect(Collectors.groupingBy(TunnelInformation::getRoadSegmentId));
            for (Map.Entry<String, List<TunnelInformation>> entry : collect.entrySet()) {
                for (InspectForRoadSegment inspectForRoadSegment : inspectForRoadSegments) {
                    if (entry.getKey().equals(inspectForRoadSegment.getRoadSegmentId())) {
                        List<TunnelInformation> tunnelInformationList = entry.getValue();
                        List<String> tunnelGroupId = tunnelInformationList.stream().map(TunnelInformation::getId).collect(Collectors.toList());
                        Integer valueUnFinishInteger = statisticalStatementDao.countTunnelCheckYear(map, tunnelGroupId);
                        inspectForRoadSegment.setValueFinish(String.valueOf(valueUnFinishInteger));
                        inspectForRoadSegment.setValueUnFinish(String.valueOf(tunnelInformationList.size()));
                    }
                }
            }

        } else {
            Circle circle = new Circle();
            circle.setName("应巡检");
            circle.setValue(String.valueOf(list.size()));
            //实际巡检
            Circle circle2 = new Circle();
            circle2.setName("实际巡检");
            List<String> tunnelId = list.stream().map(TunnelInformation::getId).collect(Collectors.toList());
            Integer integer = statisticalStatementDao.countTunnelCheckMouth(map, tunnelId);
            circle2.setValue(String.valueOf(integer));
            circles.add(circle);
            circles.add(circle2);
            Map<String, List<TunnelInformation>> collect = list.stream().collect(Collectors.groupingBy(TunnelInformation::getRoadSegmentId));
            for (Map.Entry<String, List<TunnelInformation>> entry : collect.entrySet()) {
                for (InspectForRoadSegment inspectForRoadSegment : inspectForRoadSegments) {
                    if (entry.getKey().equals(inspectForRoadSegment.getRoadSegmentId())) {
                        List<TunnelInformation> tunnelInformationList = entry.getValue();
                        List<String> tunnelGroupId = tunnelInformationList.stream().map(TunnelInformation::getId).collect(Collectors.toList());
                        Integer valueUnFinishInteger = statisticalStatementDao.countTunnelCheckMouth(map, tunnelGroupId);
                        inspectForRoadSegment.setValueFinish(String.valueOf(valueUnFinishInteger));
                        inspectForRoadSegment.setValueUnFinish(String.valueOf(tunnelInformationList.size()));

                    }
                }

            }
        }
        HashMap<String, Object> hashMap = new HashMap<>();
        hashMap.put("circles", circles);
        hashMap.put("inspectForRoadSegments", inspectForRoadSegments);
        return hashMap;
    }

    @Override
    public Map<String, Object> countSideSlopCheck(Map<String, Object> map) {
        //圆形
        List<Circle> circles = new ArrayList<>();
        //柱形图
        List<InspectForRoadSegment> inspectForRoadSegments = new ArrayList<>();
        QueryWrapper<Road> roadQueryWrapper = new QueryWrapper<>();
        roadQueryWrapper.in(ObjectUtils.isNotEmpty(map.get("roadSegmentId")), "id_",Arrays.asList(map.get("roadSegmentId").toString().split(",")));
        List<Road> roadList = roadManager.list(roadQueryWrapper);
        roadList.forEach(s -> {
            InspectForRoadSegment inspectForRoadSegment = new InspectForRoadSegment();
            inspectForRoadSegment.setRoadSegmentId(s.getId());
            inspectForRoadSegment.setRoadSegmentName(s.getName());
            inspectForRoadSegments.add(inspectForRoadSegment);
        });
        String roadIds = roadList.stream().map(Road::getId).collect(Collectors.joining(","));
        QueryWrapper<SideSlopeInformation> sideSlopeQueryWrapper = new QueryWrapper<>();
        sideSlopeQueryWrapper.eq("IS_DELE_", "0");
        sideSlopeQueryWrapper.in(roadList.size() > 0, "ROAD_SEGMENT_ID_", Arrays.asList(roadIds.split(",")));
        List<SideSlopeInformation> list = sideSlopeInformationManager.list(sideSlopeQueryWrapper);
        //年
        Object accDateYear = map.get("accDateYear");
        //月份
        Object accDateMonth = map.get("accDateMonth");
        //应巡检次数
        if (ObjectUtils.isEmpty(accDateYear)) {
            throw new RuntimeException("请选择年份");
        }
        if (ObjectUtils.isEmpty(accDateMonth)) {
            Circle circle = new Circle();
            circle.setName("应巡检");
            circle.setValue(String.valueOf(12 * list.size()));
            //实际巡检
            Circle circle2 = new Circle();
            circle2.setName("实际巡检");
            List<String> sideSlopeId = list.stream().map(SideSlopeInformation::getId).collect(Collectors.toList());
            Integer integer = statisticalStatementDao.countSideSlopeCheckYear(map, sideSlopeId);
            circle2.setValue(String.valueOf(integer));
            circles.add(circle);
            circles.add(circle2);
            Map<String, List<SideSlopeInformation>> collect = list.stream().collect(Collectors.groupingBy(SideSlopeInformation::getRoadSegmentId));
            for (Map.Entry<String, List<SideSlopeInformation>> entry : collect.entrySet()) {
                for (InspectForRoadSegment inspectForRoadSegment : inspectForRoadSegments) {
                    if (entry.getKey().equals(inspectForRoadSegment.getRoadSegmentId())) {
                        List<SideSlopeInformation> sideSlopeInformationList = entry.getValue();
                        List<String> sideSlopeGroupId = sideSlopeInformationList.stream().map(SideSlopeInformation::getId).collect(Collectors.toList());
                        Integer valueUnFinishInteger = statisticalStatementDao.countSideSlopeCheckYear(map, sideSlopeGroupId);
                        inspectForRoadSegment.setValueFinish(String.valueOf(valueUnFinishInteger));
                        inspectForRoadSegment.setValueUnFinish(String.valueOf(12 * sideSlopeInformationList.size()));
                    }
                }
            }

        } else {
            Circle circle = new Circle();
            circle.setName("应巡检");
            circle.setValue(String.valueOf(list.size()));
            //实际巡检
            Circle circle2 = new Circle();
            circle2.setName("实际巡检");
            List<String> sideSlopeId = list.stream().map(SideSlopeInformation::getId).collect(Collectors.toList());
            Integer integer = statisticalStatementDao.countSideSlopeCheckMouth(map, sideSlopeId);
            circle2.setValue(String.valueOf(integer));
            circles.add(circle);
            circles.add(circle2);
            Map<String, List<SideSlopeInformation>> collect = list.stream().collect(Collectors.groupingBy(SideSlopeInformation::getRoadSegmentId));
            for (Map.Entry<String, List<SideSlopeInformation>> entry : collect.entrySet()) {
                for (InspectForRoadSegment inspectForRoadSegment : inspectForRoadSegments) {
                    if (entry.getKey().equals(inspectForRoadSegment.getRoadSegmentId())) {
                        List<SideSlopeInformation> sideSlopeInformationList = entry.getValue();
                        List<String> sideSlopeGroupId = sideSlopeInformationList.stream().map(SideSlopeInformation::getId).collect(Collectors.toList());
                        Integer valueUnFinishInteger = statisticalStatementDao.countSideSlopeCheckMouth(map, sideSlopeGroupId);
                        inspectForRoadSegment.setValueFinish(String.valueOf(valueUnFinishInteger));
                        inspectForRoadSegment.setValueUnFinish(String.valueOf(sideSlopeInformationList.size()));

                    }
                }

            }
        }
        HashMap<String, Object> hashMap = new HashMap<>();
        hashMap.put("circles", circles);
        hashMap.put("inspectForRoadSegments", inspectForRoadSegments);
        return hashMap;
    }

    @Override
    public Map<String, Object> countCulvertCheck(Map<String, Object> map) {
        //圆形
        List<Circle> circles = new ArrayList<>();
        //柱形图
        List<InspectForRoadSegment> inspectForRoadSegments = new ArrayList<>();
        QueryWrapper<Road> roadQueryWrapper = new QueryWrapper<>();
        roadQueryWrapper.in(ObjectUtils.isNotEmpty(map.get("roadSegmentId")), "id_", Arrays.asList(map.get("roadSegmentId").toString().split(",")));
        List<Road> roadList = roadManager.list(roadQueryWrapper);
        roadList.forEach(s -> {
            InspectForRoadSegment inspectForRoadSegment = new InspectForRoadSegment();
            inspectForRoadSegment.setRoadSegmentId(s.getId());
            inspectForRoadSegment.setRoadSegmentName(s.getName());
            inspectForRoadSegments.add(inspectForRoadSegment);
        });
        String roadIds = roadList.stream().map(Road::getId).collect(Collectors.joining(","));
        QueryWrapper<BizCulvertInformation> culvertQueryWrapper = new QueryWrapper<>();
        culvertQueryWrapper.eq("IS_DELE_", "0");
        culvertQueryWrapper.in(roadList.size() > 0, "ROAD_SEGMENT_ID_", Arrays.asList(roadIds.split(",")));
        List<BizCulvertInformation> list = culvertInformationManager.list(culvertQueryWrapper);

        //年
        Object accDateYear = map.get("accDateYear");
        //应巡检次数
        if (ObjectUtils.isEmpty(accDateYear)) {
            throw new RuntimeException("请选择年份");
        }
        if (ObjectUtils.isEmpty(map.get("startTime")) && ObjectUtils.isEmpty(map.get("endTime"))) {
            Circle circle = new Circle();
            circle.setName("应巡检");
            circle.setValue(String.valueOf(4 * list.size()));
            //实际巡检
            Circle circle2 = new Circle();
            circle2.setName("实际巡检");
            List<String> culvertId = list.stream().map(BizCulvertInformation::getId).collect(Collectors.toList());
            Integer integer = statisticalStatementDao.countCulvertCheckYear(map, culvertId);
            circle2.setValue(String.valueOf(integer));
            circles.add(circle);
            circles.add(circle2);
            Map<String, List<BizCulvertInformation>> collect = list.stream().collect(Collectors.groupingBy(BizCulvertInformation::getRoadSegmentId));
            for (Map.Entry<String, List<BizCulvertInformation>> entry : collect.entrySet()) {
                for (InspectForRoadSegment inspectForRoadSegment : inspectForRoadSegments) {
                    if (entry.getKey().equals(inspectForRoadSegment.getRoadSegmentId())) {
                        List<BizCulvertInformation> culvertInformationList = entry.getValue();
                        List<String> culvertGroupId = culvertInformationList.stream().map(BizCulvertInformation::getId).collect(Collectors.toList());
                        Integer valueUnFinishInteger = statisticalStatementDao.countCulvertCheckYear(map, culvertGroupId);
                        inspectForRoadSegment.setValueFinish(String.valueOf(valueUnFinishInteger));
                        inspectForRoadSegment.setValueUnFinish(String.valueOf(4 * culvertInformationList.size()));
                    }
                }
            }
        } else {
            Circle circle = new Circle();
            circle.setName("应巡检");
            circle.setValue(String.valueOf(list.size()));
            //实际巡检
            Circle circle2 = new Circle();
            circle2.setName("实际巡检");
            List<String> culvertId = list.stream().map(BizCulvertInformation::getId).collect(Collectors.toList());
            Integer integer = statisticalStatementDao.countCulvertCheckMouth(map, culvertId);
            circle2.setValue(String.valueOf(integer));
            circles.add(circle);
            circles.add(circle2);
            Map<String, List<BizCulvertInformation>> collect = list.stream().collect(Collectors.groupingBy(BizCulvertInformation::getRoadSegmentId));
            for (Map.Entry<String, List<BizCulvertInformation>> entry : collect.entrySet()) {
                for (InspectForRoadSegment inspectForRoadSegment : inspectForRoadSegments) {
                    if (entry.getKey().equals(inspectForRoadSegment.getRoadSegmentId())) {
                        List<BizCulvertInformation> culvertInformationList = entry.getValue();
                        List<String> culvertGroupId = culvertInformationList.stream().map(BizCulvertInformation::getId).collect(Collectors.toList());
                        Integer valueUnFinishInteger = statisticalStatementDao.countCulvertCheckMouth(map, culvertGroupId);
                        inspectForRoadSegment.setValueFinish(String.valueOf(valueUnFinishInteger));
                        inspectForRoadSegment.setValueUnFinish(String.valueOf(culvertInformationList.size()));
                    }
                }

            }
        }


        HashMap<String, Object> hashMap = new HashMap<>();
        hashMap.put("circles", circles);
        hashMap.put("inspectForRoadSegments", inspectForRoadSegments);
        return hashMap;
    }

    @Override
    public List<MqiDataVo> countMqiReport(Map<String, Object> map) {

//        BizMqiCheckDataVo
        //1.查询对应的mqi数据
        //1.1查询
        QueryWrapper<BizMqiCheckData> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(ObjectUtils.isNotEmpty(map.get("roadSegmentId")), "ROAD_SEGMENT_ID_", map.get("roadSegmentId"));
        queryWrapper.eq(ObjectUtils.isNotEmpty(map.get("year")), "YEAR_", map.get("year"));
        List<MqiDataVo> vos = new ArrayList<>();
        List<BizMqiCheckData> list = bizMqiCheckDataManager.list(queryWrapper);
        //查询出来按照车道进行分组
        Map<String, List<BizMqiCheckData>> collect = list.stream().collect(Collectors.groupingBy(BizMqiCheckData::getLane));
        for (Map.Entry<String, List<BizMqiCheckData>> entry : collect.entrySet()) {
            MqiDataVo mqiDataVo = new MqiDataVo();
            List<BizMqiCheckData> bizMqiCheckData = entry.getValue();
            BizMqiCheckData checkData = bizMqiCheckData.get(0);
            mqiDataVo.setLane(checkData.getLane());
            mqiDataVo.setLaneValue(checkData.getLaneValue());

            List<String> bizMqiCheckDataIds = bizMqiCheckData.stream().map(BizMqiCheckData::getId).collect(Collectors.toList());
            //mqiAvg
            Float mqiAvg = statisticalStatementDao.countMqiAvg(bizMqiCheckDataIds);
            mqiDataVo.setMqiAvg(mqiAvg);
            //pqiAvg
            Float pqiAvg = statisticalStatementDao.countPqiAvg(bizMqiCheckDataIds);
            mqiDataVo.setPqiAvg(pqiAvg);
            //pciAvg
            Float pciAvg = statisticalStatementDao.countPciAvg(bizMqiCheckDataIds);
            mqiDataVo.setPciAvg(pciAvg);
            //rqiAvg
            Float rqiAvg = statisticalStatementDao.countRqiAvg(bizMqiCheckDataIds);
            mqiDataVo.setRqiAvg(rqiAvg);
            //rdiAvg
            Float rdiAvg = statisticalStatementDao.countRdiAvg(bizMqiCheckDataIds);
            mqiDataVo.setRdiAvg(rdiAvg);
            //pbiAvg
            Float pbiAvg = statisticalStatementDao.countPbiAvg(bizMqiCheckDataIds);
            mqiDataVo.setPbiAvg(pbiAvg);
            //sriAvg
            Float sriAvg = statisticalStatementDao.countSriAvg(bizMqiCheckDataIds);
            mqiDataVo.setSriAvg(sriAvg);
            //sciAvg
            Float sciAvg = statisticalStatementDao.countSciAvg(bizMqiCheckDataIds);
            mqiDataVo.setSciAvg(sciAvg);
            //bciAvg
            Float bciAvg = statisticalStatementDao.countBciAvg(bizMqiCheckDataIds);
            mqiDataVo.setBciAvg(bciAvg);
            //tciAvg
            Float tciAvg = statisticalStatementDao.countTciAvg(bizMqiCheckDataIds);
            mqiDataVo.setTciAvg(tciAvg);
            //pwiAvg
            Float pwiAvg = statisticalStatementDao.countPwiAvg(bizMqiCheckDataIds);
            mqiDataVo.setPwiAvg(pwiAvg);
            //pssiAvg
            Float pssiAvg = statisticalStatementDao.countPssiAvg(bizMqiCheckDataIds);
            mqiDataVo.setPssiAvg(pssiAvg);
            vos.add(mqiDataVo);
        }

        return vos;
    }

    @Override
    public List<CountStructureVo> countStructure(Map<String, Object> map) {
        List<CountStructureVo> countStructureVos = statisticalStatementDao.countStructure(map);
        return countStructureVos;
    }

    @Override
    public Map<String, Object> countMaintenanceNew(Map<String, Object> map) {
        if (ObjectUtils.isEmpty(map.get("roadSegmentId"))) {
            throw new RuntimeException("请选择路段");
        }
        List<MaintenanceNewVo> maintenanceNewVos = new ArrayList<>();
        String roadSegmentId = map.get("roadSegmentId").toString();
        List<String> ids = Arrays.asList(map.get("roadSegmentId").toString().split(","));
        map.put("ids",ids);
        List<BizCourseDetails> bizCourseDetailsRoad = bizCourseDetailsManager.getByParentIdRoad("", roadSegmentId);
        //判断是通用的成本科目还是该路段独有的成本科目
        if (CollectionUtils.isEmpty(bizCourseDetailsRoad)) {
            //通用的成本科目
            List<BizCourseDetails> bizCourseDetails = bizCourseDetailsManager.getByParentIdRoad("CBKM", "");
            if (CollectionUtils.isNotEmpty(bizCourseDetails)) {
                countMaintence(map, maintenanceNewVos, bizCourseDetails);

            }
        } else {
            //该路段独有的
            List<BizCourseDetails> bizCourseDetailsRoadPareant = bizCourseDetailsManager.getByParentIdRoad(bizCourseDetailsRoad.get(0).getSubjectCode(), roadSegmentId);
            if (CollectionUtils.isNotEmpty(bizCourseDetailsRoadPareant)) {
                countMaintence(map, maintenanceNewVos, bizCourseDetailsRoadPareant);
            }
        }
        HashMap<String, Object> resultMap = new HashMap<>();
        resultMap.put("maintenanceNewVos", maintenanceNewVos);
        return resultMap;
    }

    private void countMaintence(Map<String, Object> map, List<MaintenanceNewVo> maintenanceNewVos, List<BizCourseDetails> bizCourseDetailsRoadPareant) {
        List<CountMaintenanceNew> countMaintenanceNews = statisticalStatementDao.countMaintenanceNew(map);
        countMaintenanceNews.forEach(s -> {
            if (StringUtils.isNotEmpty(s.getSubjectNames())) {
                String[] split = s.getSubjectNames().split(",");
                if (split.length > 0) {
                    s.setSubjectNames(split[0]);
                }
            }
        });

        Map<String, List<CountMaintenanceNew>> listMap = countMaintenanceNews.stream().collect(Collectors.groupingBy(CountMaintenanceNew::getSubjectNames));
        //保证每次返回给前端的类型全部都有
        for (BizCourseDetails bizCourseDetails : bizCourseDetailsRoadPareant) {
            MaintenanceNewVo vo = new MaintenanceNewVo();
            vo.setPcode(bizCourseDetails.getSubjectCode());
            vo.setPname(bizCourseDetails.getSubjectName());
            maintenanceNewVos.add(vo);
        }

        for (String key : listMap.keySet()) {
            for (MaintenanceNewVo vo : maintenanceNewVos) {
                if (vo.getPname().equals(key)) {
                    vo.setPnameCount(String.valueOf(listMap.get(key).size()));
                    String collect = listMap.get(key).stream().map(CountMaintenanceNew::getAuditMoney).collect(Collectors.joining(","));
                    //对金额进行求和
                    BigDecimal reduce = Arrays.stream(collect.split(",")).filter(StringUtils::isNotEmpty).filter(s -> !"null".equals(s)).map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
                    vo.setEveryMoney(String.valueOf(reduce));
                }
            }
        }
    }

    //获取父id
    private Org getPrentId(String orgId) {
        Org org = orgManager.getById(orgId);
        if (org != null) {
            return orgManager.getById(org.getParentId());
        }
        return null;
    }

    /**
     * 获取管养信息统计数量
     * @return
     */
    @Override
    public List<OrgMessageVo> getMessageCountVo() {
        String orgId ;
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())&&!"0".equals(baseContext.getCurrentOrgId())){
            orgId = baseContext.getCurrentOrgId();
        }else {
            orgId = "1419863231459102720";
        }
        List<OrgMessageVo> lists = new ArrayList<>();

        List<Org> rtnList = new ArrayList<Org>();

        QueryWrapper<Org> rgQueryWrapper = new QueryWrapper<>();
        rgQueryWrapper.eq("is_dele_","0");
        List<Org> allList = orgDao.selectList(rgQueryWrapper);

        List<Org> list =getOrgChild(allList, orgId, rtnList);
        for (Org org: list){
            OrgMessageVo fvo = new OrgMessageVo();
            BeanUtils.copyProperties(org,fvo);
            lists.add(fvo);
        }
        lists = getChild(lists,orgId);


        return this.setCount(lists);
    }



    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            // 遍历出父id等于参数的id，add进子节点集合
            if (parentId.equals(org.getParentId())) {
                // 递归遍历下一级
                getOrgChild(orgList, org.getId(), rtnList);
                rtnList.add(org);
            }
        }
        return rtnList;
    }

    public static List<OrgMessageVo> getChild(List<OrgMessageVo> allList, String pCode) {
        List<OrgMessageVo> returnList = new ArrayList<>();
        for (OrgMessageVo entity : allList){
            if (pCode.equals(entity.getParentId())) {
                entity.setChirldren(getChild(allList, entity.getId()));
                returnList.add(entity);
            }
        }
        return returnList;
    }



    private List<OrgMessageVo> setCount(List<OrgMessageVo> list) {
        // 获取迭代器
        Iterator<OrgMessageVo> it = list.iterator();

        while(it.hasNext()){
            OrgMessageVo orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<>();
            if (grade<4){
                QueryWrapper<Road> roadQueryWrapper = new QueryWrapper<>();
                roadQueryWrapper.like( "COMPANY_IDS_", orgVO.getId());
                roadList = roadManager.list(roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }else if (grade==4){
                QueryWrapper<Road> roadByNameQueryWrapper = new QueryWrapper<>();
                roadByNameQueryWrapper.eq("NAME_",orgVO.getName());
                roadList =
                        roadManager.list(roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size()>0){
                orgVO = this.newCountWorkOrder(roadList,orgVO);
            }else {
                it.remove();
            }
            if (orgVO.getChirldren().size()>0&&Integer.valueOf(orgVO.getGrade())<4){
                this.setCount(orgVO.getChirldren());
            }
        }
        return list;
    }

    //统计表格
    public OrgMessageVo newCountWorkOrder(List<String> roadList,OrgMessageVo orgVO) {
        BigDecimal decimalAll = new BigDecimal(2);
        //桥梁
        QueryWrapper<BridgeInformation> bridgeQueryWrapper = new QueryWrapper<>();
        bridgeQueryWrapper.in(roadList != null && roadList.size() > 0, "ROAD_SEGMENT_ID_", roadList);
        List<BridgeInformation> bridgeList = bridgeInformationManager.list(bridgeQueryWrapper);

        //所有大桥
        orgVO.setBridgeCount(bridgeList.size());
        double bridgeSum = bridgeList.stream().mapToDouble(BridgeInformation::getLength).sum();
        BigDecimal bridgeDecimal = new BigDecimal(bridgeSum);
        BigDecimal bridgeLinearMeter = bridgeDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
        BigDecimal bridgeSingleCount = bridgeLinearMeter.divide(decimalAll);
        orgVO.setBridgeLinearMeter(bridgeLinearMeter);
        orgVO.setBridgeSingleCount(bridgeSingleCount);
        //特大桥
        long extraBigBridgeCount = bridgeList.stream().filter(s -> "1".equals(s.getType())).count();
        double extraBigBridgeLinearMeterSum = bridgeList.stream().filter(s -> "1".equals(s.getType())).mapToDouble(BridgeInformation::getLength).sum();
        BigDecimal extraBigBridgeLinearMeterBigDecimal = new BigDecimal(extraBigBridgeLinearMeterSum);
        BigDecimal extraBigBridgeLinearMeter = extraBigBridgeLinearMeterBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
        BigDecimal extraBigBridgeSingleCount = extraBigBridgeLinearMeter.divide(decimalAll);
        orgVO.setExtraBigBridgeCount(Integer.parseInt(String.valueOf(extraBigBridgeCount)));
        orgVO.setExtraBigBridgeLinearMeter(extraBigBridgeLinearMeter);
        orgVO.setExtraBigBridgeSingleCount(extraBigBridgeSingleCount);
        //大桥 bigBridgeCount
        long bigBridgeCount = bridgeList.stream().filter(s -> "2".equals(s.getType())).count();

        double bigSum = bridgeList.stream().filter(s -> "2".equals(s.getType())).mapToDouble(BridgeInformation::getLength).sum();
        BigDecimal decimal = new BigDecimal(bigSum);
        //大桥桥梁延米总长
        BigDecimal bigBridgeLinearMeter = decimal.setScale(2, BigDecimal.ROUND_HALF_UP);
        //大桥桥梁单幅总长
        BigDecimal bigBridgeSingleCount = bigBridgeLinearMeter.divide(decimalAll);
        orgVO.setBigBridgeCount(Integer.parseInt(String.valueOf(bigBridgeCount)));
        orgVO.setBigBridgeSingleCount(bigBridgeSingleCount);
        orgVO.setBigBridgeLinearMeter(bigBridgeLinearMeter);
        //中桥 middleBridgeCount
        long middleBridgeCount = bridgeList.stream().filter(s -> "3".equals(s.getType())).count();
        double middleSum = bridgeList.stream().filter(s -> "3".equals(s.getType())).mapToDouble(BridgeInformation::getLength).sum();
        BigDecimal middleSumDecimal = new BigDecimal(middleSum);
        //中桥桥梁延米总长
        BigDecimal middleBridgeLinearMeter = middleSumDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
        BigDecimal middleBridgeSingleCount = middleBridgeLinearMeter.divide(decimalAll);
        orgVO.setMiddleBridgeCount(Integer.parseInt(String.valueOf(middleBridgeCount)));
        orgVO.setMiddleBridgeLinearMeter(middleBridgeLinearMeter);
        orgVO.setMiddleBridgeSingleCount(middleBridgeSingleCount);
        //小桥 smallBridgeCount
        long smallBridgeCount = bridgeList.stream().filter(s -> "4".equals(s.getType())).count();
        double smallBridgeSum = bridgeList.stream().filter(s -> "4".equals(s.getType())).mapToDouble(BridgeInformation::getLength).sum();
        BigDecimal smallBridgeBigDecimal = new BigDecimal(smallBridgeSum);
        BigDecimal smallBridgeLinearMeter = smallBridgeBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
        BigDecimal smallBridgeSingleCount = smallBridgeLinearMeter.divide(decimalAll);
        orgVO.setSmallBridgeCount(Integer.parseInt(String.valueOf(smallBridgeCount)));
        orgVO.setSmallBridgeLinearMeter(smallBridgeLinearMeter);
        orgVO.setSmallBridgeSingleCount(smallBridgeSingleCount);

        //隧道
        QueryWrapper<TunnelInformation> tunnelQueryWrapper = new QueryWrapper<>();
        tunnelQueryWrapper.in(roadList != null && roadList.size() > 0, "ROAD_SEGMENT_ID_", roadList);
        List<TunnelInformation> tunnelList = tunnelInformationManager.list(tunnelQueryWrapper);

        orgVO.setTunnelCount(Integer.parseInt(String.valueOf(tunnelList.size())));
        double tunnelSum = tunnelList.stream().mapToDouble(TunnelInformation::getLength).sum();
        BigDecimal tunnelBigDecimal = new BigDecimal(tunnelSum);
        BigDecimal tunnelLinearMeter = tunnelBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
        BigDecimal tunnelSingleCount = tunnelLinearMeter.divide(decimalAll);
        orgVO.setTunnelSingleCount(tunnelSingleCount);
        orgVO.setTunnelLinearMeter(tunnelLinearMeter);
        //特长
        long extraBigTunnelCount = tunnelList.stream().filter(s -> "1".equals(s.getType())).count();
        double extraBigSum = tunnelList.stream().filter(s -> "1".equals(s.getType())).mapToDouble(TunnelInformation::getLength).sum();
        BigDecimal extraBigBigDecimal = new BigDecimal(extraBigSum);
        BigDecimal extraBigTunnelLinearMeter = extraBigBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
        BigDecimal extraBigTunnelSingleCount = extraBigTunnelLinearMeter.divide(decimalAll);
        orgVO.setExtraBigTunnelCount(Integer.parseInt(String.valueOf(extraBigTunnelCount)));
        orgVO.setExtraBigTunnelSingleCount(extraBigTunnelSingleCount);
        orgVO.setExtraBigTunnelLinearMeter(extraBigTunnelLinearMeter);
        //长
        long bigTunnelCount = tunnelList.stream().filter(s -> "2".equals(s.getType())).count();
        double bigTunnelSum = tunnelList.stream().filter(s -> "2".equals(s.getType())).mapToDouble(TunnelInformation::getLength).sum();
        BigDecimal bigTunnelBigDecimal = new BigDecimal(bigTunnelSum);
        BigDecimal bigTunnelLinearMeter = bigTunnelBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
        BigDecimal bigTunnelSingleCount = bigTunnelLinearMeter.divide(decimalAll);
        orgVO.setBigTunnelCount(Integer.parseInt(String.valueOf(bigTunnelCount)));
        orgVO.setBigTunnelSingleCount(bigTunnelSingleCount);
        orgVO.setBigTunnelLinearMeter(bigTunnelLinearMeter);
        //中
        long middleTunnelCount = tunnelList.stream().filter(s -> "3".equals(s.getType())).count();
        double middleTunnelSum = tunnelList.stream().filter(s -> "3".equals(s.getType())).mapToDouble(TunnelInformation::getLength).sum();
        BigDecimal middleTunnelBigDecimal = new BigDecimal(middleTunnelSum);
        BigDecimal middleTunnelLinearMeter = middleTunnelBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
        BigDecimal middleTunnelSingleCount = middleTunnelLinearMeter.divide(decimalAll);
        orgVO.setMiddleTunnelCount(Integer.parseInt(String.valueOf(middleTunnelCount)));
        orgVO.setMiddleTunnelSingleCount(middleTunnelSingleCount);
        orgVO.setMiddleTunnelLinearMeter(middleTunnelLinearMeter);
        //短
        long smallTunnelCount = tunnelList.stream().filter(s -> "4".equals(s.getType())).count();
        double smallTunnelCountSum = tunnelList.stream().filter(s -> "4".equals(s.getType())).mapToDouble(TunnelInformation::getLength).sum();
        BigDecimal smallTunnelCountBigDecimal = new BigDecimal(smallTunnelCountSum);
        BigDecimal smallTunnelCountLinearMeter = smallTunnelCountBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
        BigDecimal smallTunnelCountSingleCount = smallTunnelCountLinearMeter.divide(decimalAll);
        orgVO.setSmallTunnelCount(Integer.parseInt(String.valueOf(smallTunnelCount)));
        orgVO.setSmallTunnelSingleCount(smallTunnelCountSingleCount);
        orgVO.setSmallTunnelLinearMeter(smallTunnelCountLinearMeter);

        //涵洞数量
        QueryWrapper<BizCulvertInformation> culvertQueryWrapper = new QueryWrapper<>();
        culvertQueryWrapper.in(roadList != null && roadList.size() > 0, "ROAD_SEGMENT_ID_", roadList);
        List<BizCulvertInformation> culvertInformationList = culvertInformationManager.list(culvertQueryWrapper);
        orgVO.setCulvertCount(culvertInformationList.size());

        //边坡数量
        QueryWrapper<SideSlopeInformation> sideSlopeQueryWrapper = new QueryWrapper<>();
        sideSlopeQueryWrapper.in(roadList != null && roadList.size() > 0, "ROAD_SEGMENT_ID_", roadList);
        List<SideSlopeInformation> slopeInformationList = sideSlopeInformationManager.list(sideSlopeQueryWrapper);

        orgVO.setSideSlopeCount(slopeInformationList.size());
        return  orgVO;

    }

}
