package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.model.BizProjectSecurityProtection;
import com.artfess.yhxt.specialproject.model.BizProjectSecurityProtection;
import com.artfess.yhxt.specialproject.dao.BizProjectSecurityProtectionDao;
import com.artfess.yhxt.specialproject.manager.BizProjectSecurityProtectionManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

/**
 * 项目安全环保信息表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-18
 */
@Service
public class BizProjectSecurityProtectionManagerImpl extends BaseManagerImpl<BizProjectSecurityProtectionDao, BizProjectSecurityProtection> implements BizProjectSecurityProtectionManager {

    @Override
    public PageList<BizProjectSecurityProtection> queryBizProjectSecurityProtection(QueryFilter<BizProjectSecurityProtection> queryFilter) {
        IPage<BizProjectSecurityProtection> result = baseMapper.queryBizProjectSecurityProtection(convert2IPage(queryFilter.getPageBean()),convert2Wrapper(queryFilter,currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizProjectSecurityProtection getBizProjectSecurityProtectionById(String id) {
        BizProjectSecurityProtection bizProjectSecurityProtection = baseMapper.selectById(id);
        return bizProjectSecurityProtection;
    }
}
