package com.artfess.yhxt.specialproject.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.base.manager.BaseManager;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 工程附件表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-12
 */
public interface BizEngineeringAccessoriesManager extends BaseManager<BizEngineeringAccessories> {

    PageList<BizEngineeringAccessories> queryBizEngineeringAccessories(QueryFilter<BizEngineeringAccessories> queryFilter);

    BizEngineeringAccessories getBizEngineeringAccessoriesById(String id);

    String minioDrawingUpload(MultipartFile file, String sourceId);


    /**
     *
     * @param file 文件
     * @param bizPath 路径
     * @param fileName 文件名
     * @param customBucket 桶名
     * @param sourceId 资源ID
     * @return
     */
    BizEngineeringAccessories minIoUpload(MultipartFile file,  String bizPath, String fileName, String customBucket,String sourceId);

    /**
     * @param ids 文件ids
     * @param filePath 相对路径
     * @param response 相应对象
     * @param bizPath 路径
     */
    void minIoDownFile(String ids, String bizPath, String filePath, String customBucket, HttpServletResponse response) throws Exception;

    /**
     * 专项附件通用下载
     * @param ids 文件ids
     * @param bizPath 路径
     * @param response
     * @throws Exception
     */
    void minIoAllDownFile(String ids,String bizPath,  HttpServletResponse response) throws Exception;

    /**
     * 删除图片
     * @param id
     */
    void minIoRemoveFile(String id,String bizPath,String customBucket);

    /**
     * 根据资源id删除图片
     */
    void removeEngineeringAccessories(String sourceId);
    /**
     * 根据资源id查询附件信息
     */
    List<BizEngineeringAccessories>  getEngineeringAccessoriesBySourceId(String sourceId);
}
