package com.artfess.yhxt.specialproject.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialcheck.vo.ApplicationForChangeOfContractVo;
import com.artfess.yhxt.specialproject.model.BizApplicationForChangeOfContract;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.specialproject.vo.ChangeContractVo;
import com.artfess.yhxt.specialproject.vo.ProjectContractVo;

/**
 * 合同变更申请表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-12
 */
public interface BizApplicationForChangeOfContractManager extends BaseManager<BizApplicationForChangeOfContract> {

    PageList<BizApplicationForChangeOfContract> queryBizApplicationForChangeOfContract(QueryFilter<BizApplicationForChangeOfContract> queryFilter);

    BizApplicationForChangeOfContract getBizApplicationForChangeOfContractById(String id);

    /**
     * 修改vo
     * @param vo
     */
    void saveVo(ApplicationForChangeOfContractVo vo);

    PageList<ProjectContractVo> queryApplicationForChangeOfContractVo(QueryFilter<BizApplicationForChangeOfContract> queryFilter);

    /**
     * 根据项目合同ID查询
     * @param id 项目合同id
     * @return ChangeContractVo
     */
    ChangeContractVo getChangeContractVoById(String id);

    /**
     * 审核通过后 合同变更数据同步至合同表
     * @param vo
     */
    void synchronousContractData(ChangeContractVo vo);
}
