package com.artfess.yhxt.specialproject.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.hasor.utils.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.specialproject.manager.BizEngineeringAccessoriesManager;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

/**
 * 工程附件表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-12
 */
@RestController
@RequestMapping("/bizEngineeringAccessories/v1/")
@Api(tags = "工程附件管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizEngineeringAccessoriesController extends BaseController<BizEngineeringAccessoriesManager, BizEngineeringAccessories> {

    @Resource
    private PermissionUtils permissionUtils;

    @Resource
    private BaseContext baseContext;

    @PostMapping("/minioDrawingUpload")
    @ApiOperation(value = "工程图纸文件上传接口")
    public CommonResult<String> minioDrawingUpload(MultipartFile file,
                                                   @ApiParam(name = "sourceId", value = "资源Id", required = true)
                                                   @RequestParam(value = "sourceId", required = true) String sourceId) {

        return new CommonResult<>(this.baseService.minioDrawingUpload(file, sourceId));
    }

    @GetMapping("/minIoAllDownFile")
    @ApiOperation(value = "专项通用下载接口")
    public void minioDrawingUpload( @ApiParam(name = "ids", value = "ids", required = true)
                                        @RequestParam(value = "ids", required = true) String ids,
                                    @ApiParam(name = "bizPath", value = "bizPath", required = true)
                                    @RequestParam(value = "bizPath", required = true)String bizPath,HttpServletResponse response) throws Exception {

        this.baseService.minIoAllDownFile(ids, bizPath,response);
    }

    @RequestMapping(value = "/saveConstructionLog",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改工程附件信息",httpMethod = "POST")
    public CommonResult<String> saveEngineeringProject(@ApiParam(name = "bizEngineeringAccessories",value = "工程附件对象") @RequestBody BizEngineeringAccessories bizEngineeringAccessories) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(bizEngineeringAccessories.getId())){
            bizEngineeringAccessories.setIsDele("0");
            baseService.create(bizEngineeringAccessories);
        }else {
            baseService.update(bizEngineeringAccessories);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }


    @RequestMapping(value = "/getJson",method = RequestMethod.POST,produces = {"application/json;charset=utf-8" })
    @ApiOperation(value = "分页查询工程附件",httpMethod ="POST")
    public PageList<BizEngineeringAccessories> getJson(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizEngineeringAccessories> queryFilter){
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermissionByCreateOrgId(queryFilter);
        }
        PageList<BizEngineeringAccessories> pageList = baseService.queryBizEngineeringAccessories(queryFilter);
        return pageList;
    }

    @GetMapping(value = "get/{id}")
    @ApiOperation(value = "根据ID查询工程附件信息",httpMethod = "GET",notes = "根据ID查询工程附件")
    public BizEngineeringAccessories get(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getBizEngineeringAccessoriesById(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除工程附件",httpMethod = "DELETE",notes = "批量删除工程附件")
    public CommonResult<String> removes(@ApiParam(name = "ids",value = "对各主键用逗号分隔",required = true) @RequestParam String... ids) throws Exception{
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true,"删除成功");
    }

    @RequestMapping(value = "/updateEngineeringAccessories",method = RequestMethod.DELETE,produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除工程附件",httpMethod = "DELETE",notes = "逻辑删除工程附件")
    public CommonResult<String> updateEngineeringAccessories(@ApiParam(name = "ids",value = "ID集合以，隔开",required = true)
                                              @RequestParam(value = "ids",required = true)String ids)throws Exception{
        if (StringUtils.isNotBlank(ids)){
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizEngineeringAccessories> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_",idsList);
            updateWrapper.set("is_dele_","1");
            baseService.update(null,updateWrapper);
        }
        return new CommonResult<>(true,"删除成功");
    }
}
