package com.artfess.yhxt.contract.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.yhxt.contract.manager.PreviewManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

/**
 * @author zhx
 * @create 2022/6/24
 */
@RestController
@RequestMapping("/preview/v1/")
@Api(tags = "预览接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class PreviewController {
    @Resource
    private PreviewManager previewManager;
    @RequestMapping(value = "exportWorkOrder", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "单个工单导出-预览接口", httpMethod = "GET", notes = "单个工单导出-预览接口")
    private CommonResult<String> previewWorkOrder(@ApiParam(name = "ids", value = "工单id用逗号分割", required = true) @RequestParam String ids, HttpServletResponse response) throws Exception {
        previewManager.previewWorkOrder(ids, response);
        return null;
    }
}
