package com.artfess.yhxt.check.regular.controller;


import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.FileUtil;
import com.artfess.yhxt.check.regular.model.BridgeRegularCheck;
import com.artfess.yhxt.check.regular.vo.TunnelRegularCheckVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.check.regular.model.TunnelRegularCheck;
import com.artfess.yhxt.check.regular.manager.TunnelRegularCheckManager;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

/**
 * 隧道定期检查表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-17
 */
@RestController
@RequestMapping("/tunnelRegularCheck/v1/")
@Api(tags = "隧道定期检查接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class TunnelRegularCheckController extends BaseController<TunnelRegularCheckManager, TunnelRegularCheck> {
    @RequestMapping(value="getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询隧道定期检查",httpMethod = "POST")
    public PageList<TunnelRegularCheck> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<TunnelRegularCheck> queryFilter) {
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        PageList<TunnelRegularCheck> pageList = baseService.queryTunnelRegularCheck(queryFilter);
        return  pageList;
    }

    @RequestMapping(value = "saveTunnelRegularCheck", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存隧道定期检查信息加附件", httpMethod = "POST")
    public CommonResult<String> saveTunnelRegularCheck(@ApiParam(name = "vo", value = "定期检查vo") @RequestBody TunnelRegularCheckVo vo) throws Exception {
        String msg = "添加成功";
        this.baseService.saveTunnelRegularCheck(vo);
        return new CommonResult<String>(msg);
    }

    /**
     * 批量导入Excel数据
     *
     * @param file Excel文件
     */
    @PostMapping("/importExcelData")
    @ApiOperation(value = "Excel批量导入隧道定期检查详情数据")
    public CommonResult importExcelData(
            @ApiParam("上传文件") @RequestParam("file") MultipartFile file,
            @ApiParam(name = "mainJson", value = "主数据JSON字符数据") @RequestParam("mainJson") String mainJson) {
        baseService.importExcelData(file, JSON.parseObject(mainJson, TunnelRegularCheck.class));
        return new CommonResult<>("导入成功");
    }

    /**
     * 下载导入模板
     *
     * @param response
     * @return
     */
    @ApiOperation(value = "下载导入模板")
    @GetMapping("/downModel")
    public void downTemplate(HttpServletResponse response) throws Exception {
        ClassPathResource classPathResource = new ClassPathResource("model/tunnelRegularCheckDetail.xlsx");
        FileUtil.fileDownload(response, classPathResource.getInputStream(), "隧道定期检查导入模板.xlsx");
    }


    @RequestMapping(value = "updateTunnelRegularCheck", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "修改隧道定期检查信息", httpMethod = "POST")
    public CommonResult<String> updateTunnelRegularCheck(@ApiParam(name = "vo", value = "定期检查vo") @RequestBody TunnelRegularCheckVo vo) throws Exception {
        String msg = "修改成功";
        this.baseService.updateTunnelRegularCheck(vo);
        return new CommonResult<String>(msg);
    }

    @RequestMapping(value="get/{id}",method = RequestMethod.GET, produces={"application/json; charset=utf-8" })
    @ApiOperation(value="根据ID查询隧道定期检查信息",httpMethod = "GET",notes = "根据ID查询隧道定期检查信息")
    public TunnelRegularCheckVo get(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
        return baseService.getTunnelRegularCheckById(id);
    }

    @RequestMapping(value = "deleteTunnelRegularCheck", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除隧道定期检查信息", httpMethod = "POST", notes = "逻辑删除隧道定期检查信息")
    public CommonResult<String> deleteTunnelRegularCheck(@ApiParam(name = "ids", value = "可视化分类ID集合以，隔开", required = true)
                                                       @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<TunnelRegularCheck> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }
}
