package com.artfess.yhxt.check.regular.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.yhxt.check.regular.manager.CheckExportRegularManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

/**
 * @author zhx
 * @create 2022/3/16
 */

//@RestController
//@RequestMapping("/checkExportRegular/v1/")
//@Api(tags = "定期检查导出-检查单")
//@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class CheckExportRegularController {
    @Resource
    private CheckExportRegularManager checkExportRegularManager;

    @RequestMapping(value = "bridge/exportBridgeRegular", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "桥梁定期检查-检查单", httpMethod = "GET", notes = "桥梁定期检查-检查单")
    public void exportBridgeRegular(@ApiParam(name = "ids", value = "桥梁id用逗号分割", required = true) @RequestParam String ids, HttpServletResponse response) throws Exception {
        checkExportRegularManager.exportBridgeRegular(ids, response);
    }
}
