package com.artfess.yhxt.check.detail.model;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 桥梁经常检查明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-04
 */
@ApiModel(value="BizBridgeOftenCheckDetail对象", description="桥梁经常检查明细表")
@TableName("BIZ_BRIDGE_OFTEN_CHECK_DETAIL")
public class BridgeOftenCheckDetail extends BaseModel<BridgeOftenCheckDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "桥梁经常检查表ID")
    @TableField("BRIDGE_OFTEN_CHECK_ID_")
    private String bridgeOftenCheckId;

    @Excel(name = "部件名称", orderNum = "0")
    @ApiModelProperty(value = "名称")
    @TableField("NAME_")
    private String name;

    @Excel(name = "缺损范围", orderNum = "1")
    @ApiModelProperty(value = "缺损范围")
    @TableField("DEFECT_SCOPE_")
    private String defectScope;

    @Excel(name = "缺损类型", orderNum = "2")
    @ApiModelProperty(value = "缺损类型")
    @TableField("DEFECT_TYPE_")
    private String defectType;

    @Excel(name = "特别检查", orderNum = "3")
    @ApiModelProperty(value = "特别检查")
    @TableField("SPECIAL_CHECK_")
    private String specialCheck;

    @Excel(name = "保养措施意见", orderNum = "4")
    @ApiModelProperty(value = "保养措施意见")
    @TableField("MAINTAIN_ADVICE_")
    private String maintainAdvice;

    @Excel(name = "处理措施", orderNum = "5")
    @ApiModelProperty(value = "处理措施")
    @TableField("PROCESS_MODE_")
    private String processMode;

    @Excel(name = "备注", orderNum = "6")
    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getBridgeOftenCheckId() {
        return bridgeOftenCheckId;
    }

    public void setBridgeOftenCheckId(String bridgeOftenCheckId) {
        this.bridgeOftenCheckId = bridgeOftenCheckId;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getDefectScope() {
        return defectScope;
    }

    public void setDefectScope(String defectScope) {
        this.defectScope = defectScope;
    }
    public String getDefectType() {
        return defectType;
    }

    public void setDefectType(String defectType) {
        this.defectType = defectType;
    }
    public String getSpecialCheck() {
        return specialCheck;
    }

    public void setSpecialCheck(String specialCheck) {
        this.specialCheck = specialCheck;
    }
    public String getMaintainAdvice() {
        return maintainAdvice;
    }

    public void setMaintainAdvice(String maintainAdvice) {
        this.maintainAdvice = maintainAdvice;
    }
    public String getProcessMode() {
        return processMode;
    }

    public void setProcessMode(String processMode) {
        this.processMode = processMode;
    }

    @Override
    protected Serializable pkVal() {
        return null;
    }


    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }


    @Override
    public String toString() {
        return "BridgeOftenCheckDetail{" +
                "id='" + id + '\'' +
                ", bridgeOftenCheckId='" + bridgeOftenCheckId + '\'' +
                ", name='" + name + '\'' +
                ", defectScope='" + defectScope + '\'' +
                ", defectType='" + defectType + '\'' +
                ", specialCheck='" + specialCheck + '\'' +
                ", maintainAdvice='" + maintainAdvice + '\'' +
                ", processMode='" + processMode + '\'' +
                ", remarks='" + remarks + '\'' +
                '}';
    }
}
