package com.artfess.yhxt.budget.dao;

import com.artfess.yhxt.budget.model.YearBudgetDetailed;
import com.artfess.yhxt.budget.vo.YearBudgetDetailedVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;

/**
 * 年度总预算明细表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2021-08-02
 */
public interface YearBudgetDetailedDao extends BaseMapper<YearBudgetDetailed> {

    BigDecimal saveYearBudget(@Param("year") Integer ascriptionYear,@Param("yearBudgetId")String yearBudgetId);

    IPage<YearBudgetDetailedVo> getYearBudgetDetailed(IPage<YearBudgetDetailed> convert2IPage, @Param(Constants.WRAPPER) Wrapper<YearBudgetDetailed> convert2Wrapper);


    BigDecimal sumImageProgress(@Param("budgetId")String budgetId);

}
