package com.artfess.yhxt.basedata.vo;

import com.artfess.base.entity.BaseModel;
import com.artfess.yhxt.basedata.model.BizMaterialsManagement;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 应急物资库管理
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xmz
 * @since 2022-04-19
 */
@ApiModel(value="BizEmergeMaterialManagement对象", description="应急物资库管理")
@Data
public class BizEmergeMaterialManagementVO {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键id")
    private String id;

    @ApiModelProperty(value = "应急物资库名称")
    private String name;

    @ApiModelProperty(value = "人员数量")
    private Integer personnelQuantity;

    @ApiModelProperty(value = "应急物资库所在位置")

    private String locationMaintenanceArea;

    @ApiModelProperty(value = "经度")

    private Double lng;

    @ApiModelProperty(value = "纬度")

    private Double lat;

    @ApiModelProperty(value = "主线桩号")

    private String centPegK;

    @ApiModelProperty(value = "所在路段id(关联路段表ID)")

    private String roadSegmentId;

    @ApiModelProperty(value = "所在路段NAME")

    private String roadSegmentName;

    @ApiModelProperty(value = "公司ID")

    private String companyId;

    @ApiModelProperty(value = "所属公司名称")

    private String companyName;

    private List<BizMaterialsManagement> materialsManagements;



}
