package com.artfess.yhxt.basedata.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.*;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.yhxt.basedata.manager.BizVehicleManager;
import com.artfess.yhxt.basedata.model.BizRoadIndexCode;
import com.artfess.yhxt.basedata.model.BizVehicle;
import com.artfess.yhxt.basedata.vo.BizRoadIndexCodeVO;
import com.artfess.yhxt.basedata.vo.VehicleCountVo;
import com.artfess.yhxt.statistics.vo.Org4culvertVO;
import com.artfess.yhxt.statistics.vo.VehicleVO;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.basedata.model.BizVehicle;
import com.artfess.yhxt.basedata.manager.BizVehicleManager;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * 养护车辆管理 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-05
 */
@RestController
@RequestMapping("/bizVehicle/v1/")
@Api(tags = "车辆管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizVehicleController extends BaseController<BizVehicleManager, BizVehicle> {
    @Resource
    BizVehicleManager bizVehicleManager;
    @Resource
    BaseContext baseContext;
    @Resource
    PermissionUtils permissionUtils;
//    @RequestMapping(value = "getVehicleVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
//    @ApiOperation(value = "获取车辆统计", httpMethod = "POST", notes = "获取车辆统计")
//    public List<VehicleVO> getVehicleVo() throws Exception {
//        return baseService.getVehicleCount();
//    }


    @RequestMapping(value = "getVehicleCountVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取车辆统计", httpMethod = "POST", notes = "获取车辆统计")
    public List<VehicleCountVo> getVehicleCountVo() throws Exception {
        return baseService.getVehicleCountVo();
    }





    /**
     * 车辆管理列表(分页条件查询)数据
     *
     * @param queryFilter
     * @return
     * @throws Exception PageJson
     * @throws
     */
    @PostMapping("/list")
    @ApiOperation(value = "车辆管理数据列表", httpMethod = "POST", notes = "获取车辆管理列表")
    public PageList<BizVehicle> list(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<BizVehicle> queryFilter) throws Exception {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())) {
//            queryFilter.addFilter("COMPANY_ID_", String.join("','", baseContext.getCurrentOrgId()), QueryOP.IN, FieldRelation.AND);
            permissionUtils.addPermission(queryFilter);
        }
        return bizVehicleManager.query(queryFilter);
    }

    /**
     * 车辆信息同步
     *
     * @return
     * @throws Exception ModelAndView
     */
    @GetMapping(value = "/synCarData")
    @ApiOperation(value = "车辆信息同步", httpMethod = "GET", notes = "车辆信息同步")
    public CommonResult synCarData() throws Exception {
         bizVehicleManager.synchronizationCarData();
         return new CommonResult(true,"成功");
    }


    /**
     * 车辆设备
     *
     * @return
     * @throws Exception ModelAndView
     */
    @GetMapping(value = "/getCarList")
    @ApiOperation(value = "车辆设备", httpMethod = "GET", notes = "车辆设备")
    public CommonResult<List<BizRoadIndexCodeVO>> getCarList() throws Exception {
        return new CommonResult<List<BizRoadIndexCodeVO>>(true,"",bizVehicleManager.findAll());
    }

    /**
     * 车辆管理明细页面
     *
     * @param id
     * @return
     * @throws Exception ModelAndView
     */
    @GetMapping(value = "/get/{id}")
    @ApiOperation(value = "车辆管理数据详情", httpMethod = "GET", notes = "车辆管理数据详情")
    public BizVehicle get(@ApiParam(name = "id", value = "业务对象主键", required = true) @PathVariable String id) throws Exception {
        return bizVehicleManager.get(id);
    }

    /**
     * 新增车辆管理
     *
     * @param BizVehicle
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "/save")
    @ApiOperation(value = "新增,更新车辆管理数据", httpMethod = "POST", notes = "新增,更新车辆管理数据")
    public CommonResult<String> save(@ApiParam(name = "BizVehicle", value = "车辆管理业务对象", required = true) @RequestBody BizVehicle BizVehicle) throws Exception {
        String msg = "添加车辆管理成功";
        if (StringUtil.isEmpty(String.valueOf(BizVehicle.getId()))) {
            BizVehicle.setIsDele("0");
            bizVehicleManager.create(BizVehicle);
        } else {
            bizVehicleManager.update(BizVehicle);
            msg = "更新车辆管理成功";
        }
        return new CommonResult<String>(msg);
    }

    /**
     * 删除车辆管理记录
     *
     * @param id
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/remove/{id}")
    @ApiOperation(value = "删除车辆管理记录", httpMethod = "DELETE", notes = "删除车辆管理记录")
    public CommonResult<String> remove(@ApiParam(name = "id", value = "业务主键", required = true) @PathVariable String id) throws Exception {
        bizVehicleManager.remove(id);
        return new CommonResult<String>(true, "删除成功");
    }

    /**
     * 批量删除车辆管理记录
     *
     * @param ids
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除车辆管理记录", httpMethod = "DELETE", notes = "批量删除车辆管理记录")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        bizVehicleManager.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true, "删除成功");
    }

    @RequestMapping(value="/getList",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "不分页查询涵洞明细信息",httpMethod = "POST")
    public PageList<BizVehicle> getList(@ApiParam(name="queryFilter", value="不分页查询信息") @RequestBody QueryFilter<BizVehicle> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE);
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        PageList<BizVehicle>   road = baseService.queryBizVehicle(queryFilter);
        return road;
    }

    @RequestMapping(value="/getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询涵洞明细信息",httpMethod = "POST")
    public PageList<BizVehicle> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizVehicle> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageList<BizVehicle> pageList = baseService.queryBizVehicle(queryFilter);
        return  pageList;
    }


    @RequestMapping(value = "updateVehicle", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量逻辑删除", httpMethod = "DELETE", notes = "批量逻辑删除")
    public CommonResult<String> updateVehicle(
            @ApiParam(name = "ids", value = "涵洞ID集合以，隔开", required = true)
            @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizVehicle> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            bizVehicleManager.update(null, updateWrapper);

        }

        return new CommonResult<>(true, "批量删除成功");
    }
    @PostMapping("/minioDrawingUpload")
    @ApiOperation(value = "上传照片")
        public String minioDrawingUpload(MultipartFile file){
        String fileurl =baseService.minioDrawingUpload(file);
        return fileurl;
    }

    @PostMapping("/minioVehicleDelete")
    @ApiOperation(value = "删除照片")
    public CommonResult<String> minioVehicleDelete(String url){
        baseService.minioDrawingDelete(url);
        return new CommonResult<String>(true, "删除成功");
    }

}
