package com.artfess.yhxt.assessment.model;

import com.artfess.base.entity.BaseModel;

import java.time.LocalDateTime;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 养护考核项目表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2021-11-03
 */
@ApiModel(value="CuringAssessmentItem对象", description="养护考核项目表")
@TableName("BIZ_CURING_ASSESSMENT_ITEM")
public class CuringAssessmentItem extends BizModel<CuringAssessmentItem> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "考核内容")
    @TableField("ASSESSMENT_CONTENT_")
    private String assessmentContent;

    @ApiModelProperty(value = "权重")
    @TableField("WEIGHT_")
    private String weight;

    @ApiModelProperty(value = "详细考核内容")
    @TableField("ASSESSMENT_DETAILED_CONTENT_")
    private String assessmentDetailedContent;

    @ApiModelProperty(value = "评分标准")
    @TableField("SCORING_CRITERIA_")
    private String scoringCriteria;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "父级id，预留字段，目前没有使用")
    @TableField("PAREN_ID_")
    private String parenId;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "是否启用,0:启用，1禁用")
    @TableField("FLAG_")
    private Integer flag;



    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getAssessmentContent() {
        return assessmentContent;
    }

    public void setAssessmentContent(String assessmentContent) {
        this.assessmentContent = assessmentContent;
    }
    public String getWeight() {
        return weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }
    public String getAssessmentDetailedContent() {
        return assessmentDetailedContent;
    }

    public void setAssessmentDetailedContent(String assessmentDetailedContent) {
        this.assessmentDetailedContent = assessmentDetailedContent;
    }
    public String getScoringCriteria() {
        return scoringCriteria;
    }

    public void setScoringCriteria(String scoringCriteria) {
        this.scoringCriteria = scoringCriteria;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public String getParenId() {
        return parenId;
    }

    public void setParenId(String parenId) {
        this.parenId = parenId;
    }
    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }
    public Integer getFlag() {
        return flag;
    }

    public void setFlag(Integer flag) {
        this.flag = flag;
    }

    @Override
    protected Serializable pkVal() {
        return null;
    }

    @Override
    public String toString() {
        return "BizCuringAssessmentItem{" +
            "id=" + id +
            ", assessmentContent=" + assessmentContent +
            ", weight=" + weight +
            ", assessmentDetailedContent=" + assessmentDetailedContent +
            ", scoringCriteria=" + scoringCriteria +
            ", remarks=" + remarks +
            ", parenId=" + parenId +
            ", sn=" + sn +
            ", flag=" + flag +
        "}";
    }
}
