package com.artfess.yhxt.assessment.model;

import com.artfess.base.entity.BaseModel;

import java.time.LocalDateTime;

import com.artfess.base.entity.BizModel;
import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 养护考核明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2021-11-03
 */
@ApiModel(value="CuringAssessmentDetailed对象", description="养护考核明细表")
@TableName("BIZ_CURING_ASSESSMENT_DETAILED")
public class CuringAssessmentDetailed extends BizNoModel<CuringAssessmentDetailed> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "考核主表ID")
    @TableField("ASSESSMENT_MAIN_ID_")
    private String assessmentMainId;

    @ApiModelProperty(value = "考核项目ID")
    @TableField("ASSESSMENT_ITEM_ID_")
    private String assessmentItemId;

    @ApiModelProperty(value = "考核内容")
    @TableField("ASSESSMENT_CONTENT_")
    private String assessmentContent;

    @ApiModelProperty(value = "权重")
    @TableField("WEIGHT_")
    private String weight;

    @ApiModelProperty(value = "详细考核内容")
    @TableField("ASSESSMENT_DETAILED_CONTENT_")
    private String assessmentDetailedContent;

    @ApiModelProperty(value = "评分标准")
    @TableField("SCORING_CRITERIA_")
    private String scoringCriteria;

    @ApiModelProperty(value = "检查情况")
    @TableField("CHECK_SITUATION_")
    private String checkSituation;

    @ApiModelProperty(value = "得分")
    @TableField("SCORE_")
    private String score;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getAssessmentMainId() {
        return assessmentMainId;
    }

    public void setAssessmentMainId(String assessmentMainId) {
        this.assessmentMainId = assessmentMainId;
    }
    public String getAssessmentItemId() {
        return assessmentItemId;
    }

    public void setAssessmentItemId(String assessmentItemId) {
        this.assessmentItemId = assessmentItemId;
    }
    public String getAssessmentContent() {
        return assessmentContent;
    }

    public void setAssessmentContent(String assessmentContent) {
        this.assessmentContent = assessmentContent;
    }
    public String getWeight() {
        return weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }
    public String getAssessmentDetailedContent() {
        return assessmentDetailedContent;
    }

    public void setAssessmentDetailedContent(String assessmentDetailedContent) {
        this.assessmentDetailedContent = assessmentDetailedContent;
    }
    public String getScoringCriteria() {
        return scoringCriteria;
    }

    public void setScoringCriteria(String scoringCriteria) {
        this.scoringCriteria = scoringCriteria;
    }
    public String getCheckSituation() {
        return checkSituation;
    }

    public void setCheckSituation(String checkSituation) {
        this.checkSituation = checkSituation;
    }
    public String getScore() {
        return score;
    }

    public void setScore(String score) {
        this.score = score;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }


    @Override
    protected Serializable pkVal() {
        return null;
    }

    @Override
    public String toString() {
        return "BizCuringAssessmentDetailed{" +
            "id=" + id +
            ", assessmentMainId=" + assessmentMainId +
            ", assessmentItemId=" + assessmentItemId +
            ", assessmentContent=" + assessmentContent +
            ", weight=" + weight +
            ", assessmentDetailedContent=" + assessmentDetailedContent +
            ", scoringCriteria=" + scoringCriteria +
            ", checkSituation=" + checkSituation +
            ", score=" + score +
            ", remarks=" + remarks +
        "}";
    }
}
