/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.statistics.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.statistics.dao.WorkbenchDao;
import com.artfess.yhxt.statistics.manager.WorkbenchManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class WorkbenchManagerImpl
implements WorkbenchManager {
    @Resource
    private BaseContext baseContext;
    @Resource
    private WorkbenchDao workbenchDao;
    @Resource
    private BpmTaskManager bpmTaskManager;
    @Resource
    private OrgManager orgManager;

    @Override
    public Map<String, Object> getWorkOrder() {
        String userId = this.baseContext.getCurrentUserId();
        String userAccout = this.baseContext.getCurrentUserAccout();
        Integer siteCount = this.workbenchDao.selectSiteCount(userId);
        Integer diseaseCount = this.workbenchDao.selectDiseaseCount(userId);
        Long workOrderCount = this.bpmTaskManager.getTodoCountByUserId(this.baseContext.getCurrentUserId(), "");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("siteCount", siteCount);
        map.put("diseaseCount", diseaseCount);
        map.put("workOrderCount", workOrderCount);
        return map;
    }

    @Override
    public Map<String, Object> getOverdue() {
        String userId = this.baseContext.getCurrentUserId();
        String currentOrgId = this.baseContext.getCurrentOrgId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long diseaseOverdueCount = this.workbenchDao.selectDiseaseOverdueCount(currentOrgId);
        Long diseaseOverdueCountTrue = this.workbenchDao.selectDiseaseOverdueCountTrue(currentOrgId);
        Long workOrderOverdueCount = this.bpmTaskManager.getTodoCountByUserIdOverdue(userId);
        Long workOrderOverdueCountTrue = this.bpmTaskManager.getTodoCountByUserIdTimeOut(userId);
        map.put("diseaseOverdueCount", diseaseOverdueCount);
        map.put("diseaseOverdueCountTrue", diseaseOverdueCountTrue);
        map.put("workOrderOverdueCount", workOrderOverdueCount);
        map.put("workOrderOverdueCountTrue", workOrderOverdueCountTrue);
        return map;
    }

    @Override
    public Map<String, Object> getRegularCheck() {
        String currentOrgId = this.baseContext.getCurrentOrgId();
        List<String> ids = this.getOrgIds(currentOrgId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long brideOneCount = this.workbenchDao.brideOneCount(ids);
        Long brideThreeCount = this.workbenchDao.brideThreeCount(ids);
        Long culvertCount = this.workbenchDao.culvertCount(ids);
        Long tunnelCount = this.workbenchDao.tunnelCount(ids);
        Long sideSlopeCount = this.workbenchDao.sideSlopeCount(ids);
        map.put("brideRegularCount", brideOneCount + brideThreeCount);
        map.put("culvertRegularCount", culvertCount);
        map.put("tunnelRegularCount", tunnelCount);
        map.put("sideSlopeRegularCount", sideSlopeCount);
        return map;
    }

    private List<String> getOrgIds(String currentOrgId) {
        List orgList = this.orgManager.getByParentId(currentOrgId);
        List<String> collect = orgList.stream().map(Org::getId).collect(Collectors.toList());
        collect.add(currentOrgId);
        return collect;
    }

    @Override
    public Map<String, Object> getOftenCheck() {
        List<String> sideSlopeOftenCountList;
        List<String> tunnelThreeOftenCountList;
        List<String> tunnelTwoOftenCountList;
        List<String> tunnelOneOftenCountList;
        List<String> culvertOftenCountList;
        List<String> brideTwoOftenCountList;
        String currentOrgId = this.baseContext.getCurrentOrgId();
        List<String> ids = this.getOrgIds(currentOrgId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<String> brideOneOftenCountList = this.workbenchDao.brideOneOftenCount(ids);
        if (null == brideOneOftenCountList) {
            brideOneOftenCountList = new ArrayList<String>();
        }
        if (null == (brideTwoOftenCountList = this.workbenchDao.brideTwoOftenCount(ids))) {
            brideTwoOftenCountList = new ArrayList<String>();
        }
        if (null == (culvertOftenCountList = this.workbenchDao.culvertOftenCount(ids))) {
            culvertOftenCountList = new ArrayList<String>();
        }
        if (null == (tunnelOneOftenCountList = this.workbenchDao.tunnelOneOftenCount(ids))) {
            tunnelOneOftenCountList = new ArrayList<String>();
        }
        if (null == (tunnelTwoOftenCountList = this.workbenchDao.tunnelTwoOftenCount(ids))) {
            tunnelTwoOftenCountList = new ArrayList<String>();
        }
        if (null == (tunnelThreeOftenCountList = this.workbenchDao.tunnelThreeOftenCount(ids))) {
            tunnelThreeOftenCountList = new ArrayList<String>();
        }
        if (null == (sideSlopeOftenCountList = this.workbenchDao.sideSlopeOftenCount(ids))) {
            sideSlopeOftenCountList = new ArrayList<String>();
        }
        map.put("brideOftenCount", brideOneOftenCountList.size() + brideTwoOftenCountList.size());
        map.put("culvertOftenCount", culvertOftenCountList.size());
        map.put("tunnelOftenCount", tunnelOneOftenCountList.size() + tunnelTwoOftenCountList.size() + tunnelThreeOftenCountList.size());
        map.put("sideSlopeOftenCount", sideSlopeOftenCountList.size());
        return map;
    }
}

