/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.basedata.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.dao.BizCulvertInformationDao;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.BizCulvertInformationManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.BizCulvertInformation;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.basedata.vo.CulvertCheckVo;
import com.artfess.yhxt.basedata.vo.CulvertRegularVo;
import com.artfess.yhxt.check.regular.dao.CulvertOftenCheckDao;
import com.artfess.yhxt.check.regular.dao.CulvertRegularCheckDao;
import com.artfess.yhxt.check.regular.model.CulvertOftenCheck;
import com.artfess.yhxt.check.regular.model.CulvertRegularCheck;
import com.artfess.yhxt.statistics.dao.WorkbenchDao;
import com.artfess.yhxt.statistics.vo.Org4culvertVO;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="BizCulvertInformationManager")
public class BizCulvertInformationManagerImpl
extends BaseManagerImpl<BizCulvertInformationDao, BizCulvertInformation>
implements BizCulvertInformationManager {
    @Resource
    BizCulvertInformationDao bizCulvertInformationDao;
    @Resource
    OrgManager orgManager;
    @Resource
    WorkbenchDao workbenchDao;
    @Resource
    CulvertOftenCheckDao culvertOftenCheckDao;
    @Resource
    CulvertRegularCheckDao culvertRegularCheckDao;
    @Resource
    AccessoryManager accessoryManager;
    @Resource
    BaseContext baseContext;
    @Resource
    PermissionUtils permissionUtils;
    @Resource
    private OrgDao orgDao;
    @Resource
    private RoadManager roadManager;

    @Override
    public List<Org4culvertVO> getCulvertCount() {
        String orgId = StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
        List<Org4culvertVO> lists = new ArrayList<Org4culvertVO>();
        ArrayList<Org> rtnList = new ArrayList<Org>();
        QueryWrapper rgQueryWrapper = new QueryWrapper();
        rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
        List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
        List<Org> list = BizCulvertInformationManagerImpl.getOrgChild(allList, orgId, rtnList);
        for (Org org : list) {
            Org4culvertVO fvo = new Org4culvertVO();
            BeanUtils.copyProperties((Object)org, (Object)fvo);
            lists.add(fvo);
        }
        lists = BizCulvertInformationManagerImpl.getChild(lists, orgId);
        return this.setCount(lists);
    }

    public List<Org4culvertVO> setCount(List<Org4culvertVO> list) {
        Iterator<Org4culvertVO> it = list.iterator();
        while (it.hasNext()) {
            Org4culvertVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                orgVO = this.newCount(roadList, orgVO);
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 4) continue;
            this.setCount(orgVO.getChirldren());
        }
        return list;
    }

    public Org4culvertVO newCount(List<String> ids, Org4culvertVO orgVO) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        wrapper.eq((Object)"IS_DELE_", (Object)0);
        List culverts = this.list((Wrapper)wrapper);
        List board = culverts.stream().filter(information -> Objects.equals(information.getType(), "1")).collect(Collectors.toList());
        List pipe = culverts.stream().filter(information -> Objects.equals(information.getType(), "2")).collect(Collectors.toList());
        List box = culverts.stream().filter(information -> Objects.equals(information.getType(), "3")).collect(Collectors.toList());
        List arch = culverts.stream().filter(information -> Objects.equals(information.getType(), "4")).collect(Collectors.toList());
        List inverted = culverts.stream().filter(information -> Objects.equals(information.getType(), "5")).collect(Collectors.toList());
        List plank = culverts.stream().filter(information -> Objects.equals(information.getType(), "6")).collect(Collectors.toList());
        orgVO.setArch(arch.size());
        orgVO.setBoard(board.size());
        orgVO.setBox(box.size());
        orgVO.setInverted(inverted.size());
        orgVO.setPlank(plank.size());
        orgVO.setPipe(pipe.size());
        if ("4".equals(orgVO.getGrade())) {
            orgVO.setRoadSegmentId(ids.get(0));
        }
        return orgVO;
    }

    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            BizCulvertInformationManagerImpl.getOrgChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    public static List<Org4culvertVO> getChild(List<Org4culvertVO> allList, String pCode) {
        ArrayList<Org4culvertVO> returnList = new ArrayList<Org4culvertVO>();
        for (Org4culvertVO entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(BizCulvertInformationManagerImpl.getChild(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    @Override
    public PageList<BizCulvertInformation> queryBizCulvertInformation(QueryFilter<BizCulvertInformation> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        IPage<BizCulvertInformation> result = ((BizCulvertInformationDao)this.baseMapper).getBizCulvertInformation((IPage<BizCulvertInformation>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<BizCulvertInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void updateBizCulvertInformation(String id) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq(StringUtils.isNotBlank((CharSequence)id), (Object)"id_", (Object)id);
        updateWrapper.set((Object)"is_dele_", (Object)"1");
        this.bizCulvertInformationDao.update(null, (Wrapper)updateWrapper);
    }

    private List<String> getOrgIds(String currentOrgId) {
        List orgList = this.orgManager.getByParentId(currentOrgId);
        List<String> collect = orgList.stream().map(Org::getId).collect(Collectors.toList());
        collect.add(currentOrgId);
        return collect;
    }

    @Override
    public PageList<CulvertCheckVo> queryBizCulvert(QueryFilter<BizCulvertInformation> queryFilter) throws Exception {
        String baseContextCurrentOrgId;
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty((CharSequence)(baseContextCurrentOrgId = this.baseContext.getCurrentOrgId()))) {
            this.permissionUtils.addPermission(queryFilter);
        }
        List sorter = queryFilter.getSorter();
        for (FieldSort fieldSort : sorter) {
            if (!fieldSort.getProperty().equals("checkDate")) continue;
            fieldSort.setProperty("CHECK_DATE_");
        }
        IPage<CulvertCheckVo> result = ((BizCulvertInformationDao)this.baseMapper).queryBizCulvert((IPage<BizCulvertInformation>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<BizCulvertInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        LocalDate today = LocalDate.now();
        for (CulvertCheckVo record : records) {
            Date checkDate;
            String id = record.getId();
            QueryWrapper culvertOftenCheckQueryWrapper = new QueryWrapper();
            culvertOftenCheckQueryWrapper.eq(record.getCheckDate() != null, (Object)"CHECK_DATE_", (Object)record.getCheckDate());
            culvertOftenCheckQueryWrapper.eq((Object)"CULVERT_ID_", (Object)id);
            List culvertOftenChecks = this.culvertOftenCheckDao.selectList((Wrapper)culvertOftenCheckQueryWrapper);
            if (culvertOftenChecks != null && culvertOftenChecks.size() > 0) {
                record.setEvaluateValue(((CulvertOftenCheck)((Object)culvertOftenChecks.get(0))).getEvaluateValue());
            }
            if (null == (checkDate = record.getCheckDate())) {
                record.setTemporary(0);
                continue;
            }
            Instant instant = checkDate.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDate oldDate = instant.atZone(zoneId).toLocalDate();
            long dateLength = today.until(oldDate, ChronoUnit.DAYS);
            record.setAlreadyCheckDays((int)Math.abs(dateLength));
            Date checkNewDay = record.getCheckNewDay();
            Instant instantNew = checkNewDay.toInstant();
            LocalDate newDate = instantNew.atZone(zoneId).toLocalDate();
            long dateDivide = today.until(newDate, ChronoUnit.DAYS);
            if (dateDivide < 0L) {
                dateDivide = 0L;
            }
            record.setCheckDays((int)dateDivide);
        }
        return new PageList(result);
    }

    @Override
    public PageList<CulvertRegularVo> queryCulvertRegular(QueryFilter<BizCulvertInformation> queryFilter) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        List sorter = queryFilter.getSorter();
        for (FieldSort fieldSort : sorter) {
            if (!fieldSort.getProperty().equals("checkDate")) continue;
            fieldSort.setProperty("CHECK_DATE_");
        }
        IPage<CulvertRegularVo> result = ((BizCulvertInformationDao)this.baseMapper).queryCulvertRegularCheckVo((IPage<BizCulvertInformation>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<BizCulvertInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        LocalDate today = LocalDate.now();
        for (CulvertRegularVo record : records) {
            Date checkDate;
            String id = record.getId();
            QueryWrapper culvertRegularCheckQueryWrapper = new QueryWrapper();
            culvertRegularCheckQueryWrapper.eq(record.getCheckDate() != null, (Object)"CHECK_DATE_", (Object)record.getCheckDate());
            culvertRegularCheckQueryWrapper.eq((Object)"CULVERT_ID_", (Object)id);
            List culvertRegularChecks = this.culvertRegularCheckDao.selectList((Wrapper)culvertRegularCheckQueryWrapper);
            if (culvertRegularChecks != null && culvertRegularChecks.size() > 0) {
                record.setEvaluateValue(((CulvertRegularCheck)((Object)culvertRegularChecks.get(0))).getEvaluateValue());
            }
            if (null == (checkDate = record.getCheckDate())) {
                record.setTemporary(0);
                continue;
            }
            Instant instant = checkDate.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDate oldDate = instant.atZone(zoneId).toLocalDate();
            long dateLength = today.until(oldDate, ChronoUnit.DAYS);
            record.setAlreadyCheckDays((int)Math.abs(dateLength));
            Date checkNewDay = record.getCheckNewDay();
            Instant instantNew = checkNewDay.toInstant();
            LocalDate newDate = instantNew.atZone(zoneId).toLocalDate();
            long dateDivide = today.until(newDate, ChronoUnit.DAYS);
            if (dateDivide < 0L) {
                dateDivide = 0L;
            }
            record.setCheckDays((int)dateDivide);
        }
        return new PageList(result);
    }

    @Override
    public void saveCulvert(BizCulvertInformation bizCulvertInformation) {
        List<Accessory> accessoriesTwoDimensionalView;
        List<Accessory> accessoriesLateralView;
        this.save((Object)bizCulvertInformation);
        List<Accessory> accessoriesFrontView = bizCulvertInformation.getAccessoriesFrontView();
        if (null != accessoriesFrontView && accessoriesFrontView.size() > 0) {
            accessoriesFrontView.forEach(s -> {
                s.setSourceId(bizCulvertInformation.getId());
                s.setGroup("frontView");
            });
            this.accessoryManager.saveBatch(accessoriesFrontView);
        }
        if (null != (accessoriesLateralView = bizCulvertInformation.getAccessoriesLateralView()) && accessoriesLateralView.size() > 0) {
            accessoriesLateralView.forEach(s -> {
                s.setSourceId(bizCulvertInformation.getId());
                s.setGroup("lateralView");
            });
            this.accessoryManager.saveBatch(accessoriesLateralView);
        }
        if (null != (accessoriesTwoDimensionalView = bizCulvertInformation.getAccessoriesTwoDimensionalView()) && accessoriesTwoDimensionalView.size() > 0) {
            accessoriesTwoDimensionalView.forEach(s -> {
                s.setSourceId(bizCulvertInformation.getId());
                s.setGroup("twoDimensionalPlan");
            });
            this.accessoryManager.saveBatch(accessoriesTwoDimensionalView);
        }
    }

    @Override
    public void updateCulvert(BizCulvertInformation bizCulvertInformation) {
        List<Accessory> accessoriesTwoDimensionalView;
        List<Accessory> accessoriesLateralView;
        this.update((Model)bizCulvertInformation);
        this.accessoryManager.delAccessoryBySourceId(bizCulvertInformation.getId());
        List<Accessory> accessoriesFrontView = bizCulvertInformation.getAccessoriesFrontView();
        if (null != accessoriesFrontView && accessoriesFrontView.size() > 0) {
            accessoriesFrontView.forEach(s -> {
                s.setSourceId(bizCulvertInformation.getId());
                s.setGroup("frontView");
            });
            this.accessoryManager.saveBatch(accessoriesFrontView);
        }
        if (null != (accessoriesLateralView = bizCulvertInformation.getAccessoriesLateralView()) && accessoriesLateralView.size() > 0) {
            accessoriesLateralView.forEach(s -> {
                s.setSourceId(bizCulvertInformation.getId());
                s.setGroup("lateralView");
            });
            this.accessoryManager.saveBatch(accessoriesLateralView);
        }
        if (null != (accessoriesTwoDimensionalView = bizCulvertInformation.getAccessoriesTwoDimensionalView()) && accessoriesTwoDimensionalView.size() > 0) {
            accessoriesTwoDimensionalView.forEach(s -> {
                s.setSourceId(bizCulvertInformation.getId());
                s.setGroup("twoDimensionalPlan");
            });
            this.accessoryManager.saveBatch(accessoriesTwoDimensionalView);
        }
    }

    @Override
    public BizCulvertInformation getByCulvertId(String id) {
        BizCulvertInformation bizCulvertInformation = (BizCulvertInformation)((Object)((BizCulvertInformationDao)this.baseMapper).selectById((Serializable)((Object)id)));
        List<Accessory> accessories = this.accessoryManager.getAccessoryBySourceId(id);
        ArrayList<Accessory> accessoriesFrontView = new ArrayList<Accessory>();
        ArrayList<Accessory> accessoriesLateralView = new ArrayList<Accessory>();
        ArrayList<Accessory> accessoriesTwoDimensionalView = new ArrayList<Accessory>();
        if (accessories != null && accessories.size() > 0) {
            accessories.forEach(s -> {
                String group = s.getGroup();
                if ("frontView".equalsIgnoreCase(group)) {
                    accessoriesFrontView.add((Accessory)((Object)s));
                }
                if ("lateralView".equalsIgnoreCase(group)) {
                    accessoriesLateralView.add((Accessory)((Object)s));
                }
                if ("twoDimensionalPlan".equalsIgnoreCase(group)) {
                    accessoriesTwoDimensionalView.add((Accessory)((Object)s));
                }
            });
        }
        bizCulvertInformation.setAccessoriesFrontView(accessoriesFrontView);
        bizCulvertInformation.setAccessoriesLateralView(accessoriesLateralView);
        bizCulvertInformation.setAccessoriesTwoDimensionalView(accessoriesTwoDimensionalView);
        return bizCulvertInformation;
    }
}

