/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.assessment.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.yhxt.assessment.manager.CuringAssessmentDetailedManager;
import com.artfess.yhxt.assessment.manager.CuringAssessmentManager;
import com.artfess.yhxt.assessment.model.CuringAssessment;
import com.artfess.yhxt.assessment.vo.CuringAssessmentIVo;
import com.artfess.yhxt.contract.manager.WorkOrderInformationManager;
import com.artfess.yhxt.contract.vo.WorkOrderDiseaseVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/assessment/curingAssessment/v1/"})
@Api(tags={"\u517b\u62a4\u8003\u6838\u4fe1\u606f\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
public class CuringAssessmentController
extends BaseController<CuringAssessmentManager, CuringAssessment> {
    private static final Logger log = LoggerFactory.getLogger(CuringAssessmentController.class);
    @Resource
    private CuringAssessmentDetailedManager curingAssessmentDetailedManager;
    @Resource
    private WorkOrderInformationManager workOrderInformationManager;
    @Resource
    private BaseContext baseContext;
    @Resource
    private PermissionUtils permissionUtils;

    @RequestMapping(value={"saveCuringAssessment"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58,\u4fee\u6539\u517b\u62a4\u8003\u6838\u4fe1\u606f", httpMethod="POST")
    public CommonResult<String> saveCuringAssessment(@ApiParam(name="curingAssessmentIVo", value="\u517b\u62a4\u8003\u6838\u5bf9\u8c61") @RequestBody CuringAssessmentIVo curingAssessmentIVo) throws Exception {
        String data = ((CuringAssessmentManager)this.baseService).saveCuringAssessment(curingAssessmentIVo);
        return new CommonResult(true, "\u6570\u636e\u4fdd\u5b58\u6210\u529f", (Object)data);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u517b\u62a4\u8003\u6838\u4fe1\u606f", httpMethod="POST")
    public PageList<CuringAssessmentIVo> getJson(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<CuringAssessment> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        this.permissionUtils.addPermission(queryFilter);
        List sorter = queryFilter.getSorter();
        for (FieldSort fieldSort : sorter) {
            if (!fieldSort.getProperty().equals("startDate")) continue;
            fieldSort.setProperty("START_DATE_");
        }
        PageList pageList = ((CuringAssessmentManager)this.baseService).query(queryFilter);
        PageList pageListVo = new PageList();
        pageListVo.setPage(pageList.getPage());
        pageListVo.setPageSize(pageList.getPageSize());
        pageListVo.setTotal(pageList.getTotal());
        List rows = pageList.getRows();
        ArrayList<CuringAssessmentIVo> voRows = new ArrayList<CuringAssessmentIVo>();
        if (rows != null) {
            for (CuringAssessment curingAssessment : rows) {
                CuringAssessmentIVo curingAssessmentIVo = new CuringAssessmentIVo();
                curingAssessmentIVo.setCuringAssessment(curingAssessment);
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"ASSESSMENT_MAIN_ID_", (Object)curingAssessment.getId());
                List curingAssessmentDetailedList = this.curingAssessmentDetailedManager.list((Wrapper)queryWrapper);
                curingAssessmentIVo.setCuringAssessmentDetailedList(curingAssessmentDetailedList);
                voRows.add(curingAssessmentIVo);
            }
        }
        pageListVo.setRows(voRows);
        return pageListVo;
    }

    @RequestMapping(value={"exportCuringOrder"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u517b\u62a4\u8003\u6838\u4fe1\u606f\u5bfc\u51fa\u517b\u62a4\u5de5\u5355\u5217\u8868")
    public void exportCuringOrder(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61\uff08startTime\u5f00\u59cb\u65f6\u95f4 endTime \u7ed3\u675f\u65f6\u95f4 roadId \u8def\u6bb5id\uff09") @RequestBody QueryFilter queryFilter, HttpServletResponse response) throws Exception {
        PageList<WorkOrderDiseaseVo> workOrderVoPageList = this.workOrderInformationManager.getWorkOrder(queryFilter);
        List rows = workOrderVoPageList.getRows();
        HSSFWorkbook exportFile = ((CuringAssessmentManager)this.baseService).exportCuringOrder(rows);
        ExcelUtil.downloadExcel((HSSFWorkbook)exportFile, (String)"\u517b\u62a4\u5de5\u5355", (HttpServletResponse)response);
    }

    @RequestMapping(value={"exportCuringAssessment"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u517b\u62a4\u8003\u6838\u4fe1\u606fID\u5bfc\u51fa\u8003\u6838\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u517b\u62a4\u8003\u6838\u4fe1\u606fID\u5bfc\u51fa\u8003\u6838\u4fe1\u606f")
    public void exportCuringAssessment(@ApiParam(name="ids", value="ids", required=true) @RequestParam String ids, HttpServletResponse response) throws Exception {
        HSSFWorkbook exportFile = ((CuringAssessmentManager)this.baseService).exportCuringAssessment(ids);
        ExcelUtil.downloadExcel((HSSFWorkbook)exportFile, (String)"\u65e5\u5e38\u517b\u62a4\u8003\u6838\u8bc4\u5206\u8868", (HttpServletResponse)response);
    }
}

