package com.artfess.workflow.runtime.controller;

import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.workflow.runtime.manager.BpmTestCaseLogsManager;
import com.artfess.workflow.runtime.model.BpmTestCaseLogs;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <pre>
 * 描述：流程仿真异常日志 控制器类
 * 构建组：x7
 * 作者:heyf
 * 邮箱:heyf@jee-soft.cn
 * 日期:2020-11-04 17:14:52
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@RestController
@RequestMapping(value = "/runtime/bpmTestCaseLogs/v1")
@Api(tags = "bpmTestCaseLogsController")
public class BpmTestCaseLogsController extends BaseController<BpmTestCaseLogsManager, BpmTestCaseLogs> {
    @Resource
    BpmTestCaseLogsManager bpmTestCaseLogsManager;

    /**
     * 流程仿真异常日志列表(分页条件查询)数据
     *
     * @param request
     * @return
     * @throws Exception PageJson
     * @throws
     */
    @PostMapping("/listJson")
    @ApiOperation(value = "流程仿真异常日志数据列表", httpMethod = "POST", notes = "获取流程仿真异常日志列表")
    public PageList<BpmTestCaseLogs> list(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter queryFilter) throws Exception {
        return bpmTestCaseLogsManager.query(queryFilter);
    }

    /**
     * 流程仿真异常日志明细页面
     *
     * @param id
     * @return
     * @throws Exception ModelAndView
     */
    @GetMapping(value = "/getJson")
    @ApiOperation(value = "流程仿真异常日志数据详情", httpMethod = "GET", notes = "流程仿真异常日志数据详情")
    public BpmTestCaseLogs get(@ApiParam(name = "id", value = "业务对象主键", required = true) @RequestParam String id) throws Exception {
        return bpmTestCaseLogsManager.get(id);
    }

    /**
     * 新增流程仿真异常日志
     *
     * @param bpmTestCaseLogs
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "save")
    @ApiOperation(value = "新增,更新流程仿真异常日志数据", httpMethod = "POST", notes = "新增,更新流程仿真异常日志数据")
    public CommonResult<String> save(@ApiParam(name = "bpmTestCaseLogs", value = "流程仿真异常日志业务对象", required = true) @RequestBody BpmTestCaseLogs bpmTestCaseLogs) throws Exception {
        String msg = "添加流程仿真异常日志成功";
        if (StringUtil.isEmpty(bpmTestCaseLogs.getId())) {
            bpmTestCaseLogsManager.create(bpmTestCaseLogs);
        } else {
            bpmTestCaseLogsManager.update(bpmTestCaseLogs);
            msg = "更新流程仿真异常日志成功";
        }
        return new CommonResult<String>(msg);
    }

    /**
     * 批量删除流程仿真异常日志记录
     *
     * @param ids
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/remove")
    @ApiOperation(value = "批量删除流程仿真异常日志记录", httpMethod = "DELETE", notes = "批量删除流程仿真异常日志记录")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "业务主键数组,多个业务主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        bpmTestCaseLogsManager.removeByIds(ids);
        return new CommonResult<String>(true, "批量删除成功");
    }
}
