package com.artfess.cqxy.contract.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.contract.model.FundPlan;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2022/7/7 11:33
 */
public interface FundPlanManager extends BaseManager<FundPlan>{
    boolean deleteByIds(List<String> ids);

    /**
     * 导入Excel数据
     * @param file 文件
     * @param projectId 项目ID
     */
    void importExcelData(MultipartFile file, String projectId,String contractId);

    /**
     * 导出数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDatatoExcel(QueryFilter<FundPlan> queryFilter, HttpServletResponse response) throws IOException;

    /**
     * 导出本月数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDatatoExcel2(QueryFilter<FundPlan> queryFilter, HttpServletResponse response) throws IOException;

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    FundPlan getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 数据集合
     */
    PageList<FundPlan> queryAllByPage(QueryFilter<FundPlan> queryFilter);
}
