package com.artfess.cqxy.feasiblePlan.dao;

import com.artfess.cqxy.feasiblePlan.model.FeasibilityStudyReply;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 可研批复表(BizFeasibilityStudyReply)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-02-14 16:09:40
 */
public interface FeasibilityStudyReplyDao extends BaseMapper<FeasibilityStudyReply> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    FeasibilityStudyReply getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<FeasibilityStudyReply> queryAllByPage(IPage<FeasibilityStudyReply> convert2IPage, @Param(Constants.WRAPPER) Wrapper<FeasibilityStudyReply> convert2Wrapper);

    /**
     * 根据项目id查询工程总费用、预备总费用、土地成本、建设建设其他费用等
     * @param projectId
     * @return
     */
    FeasibilityStudyReply getByProjectId( @Param("projectId") String projectId);
}

