package com.artfess.cqxy.wps.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

/**
 * WPS 应用配置，CommandLineRunner 在应用初始化后，去执行一段代码块逻辑，
 * 这段初始化代码在整个应用生命周期内只会执行一次，这里用作WPS应用配置初始化
 * 可以考虑做成单例
 *
 * @author 黎沐华
 * @date 2022/4/26 9:45
 */
@Component
@ApiModel("Wps 应用配置")
public class WpsApp implements CommandLineRunner {

    @ApiModelProperty("")
    public static String appid = "";
    @ApiModelProperty("")
    public static String appSecret = "";
    @ApiModelProperty("")
    public static String domain = "";

    @Autowired
    public WpsApp(
            @Value("${wps.appid}") String appid,
            @Value("${wps.domain}") String domain,
            @Value("${wps.appSecret}") String appSecret) {
        WpsApp.appid = appid;
        WpsApp.appSecret = appSecret;
        WpsApp.domain = domain;
    }

    @Override
    public void run(String... args) throws Exception {

    }
}
