/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.dao.TenantIgnoreMenuDao;
import com.artfess.uc.manager.TenantIgnoreMenuManager;
import com.artfess.uc.manager.TenantManageManager;
import com.artfess.uc.model.TenantIgnoreMenu;
import com.artfess.uc.model.TenantManage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tenantIgnoreMenuManager")
public class TenantIgnoreMenuManagerImpl
extends BaseManagerImpl<TenantIgnoreMenuDao, TenantIgnoreMenu>
implements TenantIgnoreMenuManager {
    @Resource
    TenantManageManager tenantManageManager;

    @Override
    public List<TenantIgnoreMenu> getByTenantId(String tenantId) {
        return ((TenantIgnoreMenuDao)this.baseMapper).getByTenantId(tenantId);
    }

    @Override
    @Transactional
    public void deleteByTenantId(String tenantId) {
        ((TenantIgnoreMenuDao)this.baseMapper).deleteByTenantId(tenantId);
    }

    @Override
    @Transactional
    @CacheEvict(value={"bpm:sys:userMenu"}, allEntries=true)
    public CommonResult<String> saveByTenantId(String tenantId, List<String> ignoreMenus) {
        if (StringUtil.isEmpty((String)tenantId)) {
            return new CommonResult(false, "\u79df\u6237\u7981\u7528\u83dc\u5355\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff1a\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        TenantManage tenant = (TenantManage)this.tenantManageManager.get((Serializable)((Object)tenantId));
        if (BeanUtils.isEmpty((Object)((Object)tenant))) {
            return new CommonResult(false, "\u79df\u6237\u7981\u7528\u83dc\u5355\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff1a\u79df\u6237ID\u3010" + tenantId + "\u3011\u4e0d\u5b58\u5728\u3002");
        }
        ((TenantIgnoreMenuDao)this.baseMapper).deleteByTenantId(tenantId);
        if (BeanUtils.isNotEmpty(ignoreMenus)) {
            BeanUtils.removeDuplicate(ignoreMenus);
            ArrayList<TenantIgnoreMenu> nmenus = new ArrayList<TenantIgnoreMenu>();
            for (String alias : ignoreMenus) {
                TenantIgnoreMenu menu = new TenantIgnoreMenu();
                menu.setMenuCode(alias);
                menu.setTenantId(tenantId);
                nmenus.add(menu);
            }
            this.saveBatch(nmenus);
        }
        return new CommonResult(true, "\u79df\u6237\u7981\u7528\u83dc\u5355\u4fe1\u606f\u4fdd\u5b58\u6210\u529f\u3002");
    }
}

