/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.projectManagement.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cqxy.projectManagement.dao.ProjectPersonnelDao;
import com.artfess.cqxy.projectManagement.manager.ProjectPersonnelManager;
import com.artfess.cqxy.projectManagement.model.ProjectPersonnel;
import com.artfess.cqxy.projectManagement.vo.ProjectPersonnelVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ProjectPersonnelManagerImpl
extends BaseManagerImpl<ProjectPersonnelDao, ProjectPersonnel>
implements ProjectPersonnelManager {
    @Override
    public PageList<ProjectPersonnelVo> queryAllByPage(QueryFilter<ProjectPersonnel> queryFilter) {
        String projectId = null;
        List test = queryFilter.getQuerys();
        for (QueryField ele : test) {
            if (!"pp.PROJECT_ID_".equals(ele.getProperty())) continue;
            projectId = String.valueOf(ele.getValue());
            break;
        }
        Assert.notNull(projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        queryFilter.addFilter("uc.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("pp.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<ProjectPersonnelVo> result = ((ProjectPersonnelDao)this.baseMapper).queryAllByPage((IPage<ProjectPersonnel>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ProjectPersonnel>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public List<ProjectPersonnelVo> getAllUsers(String projectId) {
        return ((ProjectPersonnelDao)this.baseMapper).getAllUsers(projectId);
    }

    @Override
    @Async
    public void linkUsers(String projectId) {
        List<ProjectPersonnelVo> vo = this.getAllUsers("");
        ArrayList<ProjectPersonnel> personnels = new ArrayList<ProjectPersonnel>();
        for (ProjectPersonnelVo ele : vo) {
            ProjectPersonnel temp = new ProjectPersonnel();
            temp.setProjectId(projectId);
            temp.setPersonnelId(ele.getPersonnelId());
            personnels.add(temp);
        }
        this.saveBatch(personnels);
    }

    @Override
    @Async
    public void linkUsersByProjectManager(String projectId, String projectManagerId) {
        if (StringUtils.isBlank((CharSequence)projectManagerId) || StringUtils.isBlank((CharSequence)projectId)) {
            return;
        }
        ProjectPersonnel temp = new ProjectPersonnel();
        temp.setProjectId(projectId);
        temp.setPersonnelId(projectManagerId);
        int index = projectManagerId.indexOf(",");
        if (-1 == index) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"PROJECT_ID_", (Object)projectId);
            queryWrapper.eq((Object)"PERSONNEL_ID_", (Object)projectManagerId);
            Integer count = ((ProjectPersonnelDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
            if (count < 1) {
                ((ProjectPersonnelDao)this.baseMapper).insert((Object)temp);
            }
        } else {
            String[] projectManagerIds;
            for (String personId : projectManagerIds = projectManagerId.split(",")) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"PROJECT_ID_", (Object)projectId);
                queryWrapper.eq((Object)"PERSONNEL_ID_", (Object)personId);
                Integer count = ((ProjectPersonnelDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
                if (count >= 1) continue;
                ((ProjectPersonnelDao)this.baseMapper).insert((Object)temp);
            }
        }
    }

    @Override
    public ProjectPersonnelVo getVoById(String id) {
        return ((ProjectPersonnelDao)this.baseMapper).getVoById(id);
    }

    @Override
    public boolean batchSaveData(ProjectPersonnel perObject) {
        List<String> ids = Arrays.asList(perObject.getPersonnelId().split(","));
        ArrayList<ProjectPersonnel> dataList = new ArrayList<ProjectPersonnel>();
        for (String ele : ids) {
            ProjectPersonnel temp = new ProjectPersonnel(perObject.getProjectId(), ele);
            dataList.add(temp);
        }
        Boolean result = this.saveBatch(dataList);
        return result;
    }

    @Override
    public List<String> getProjectPersonnelByProjectId(String projectId) {
        return ((ProjectPersonnelDao)this.baseMapper).getProjectPersonnelByProjectId(projectId);
    }

    @Override
    public List<String> getProjectByPersonnelId(String personnelId) {
        return ((ProjectPersonnelDao)this.baseMapper).getProjectByPersonnelId(personnelId);
    }
}

