package com.artfess.form.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.form.model.ComponentFunctionEntity;
import com.artfess.form.model.QuerySqldef;
import com.artfess.form.persistence.dao.ComponentFunctionDao;
import com.artfess.form.persistence.manager.ComponentFunctionManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import net.hasor.web.annotation.Post;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @program: cqgs
 * @Date: 2020/9/26 16:24
 * @Author: ZQF
 * @Description: 建模引擎-元件管理-取值函数
 */
@Slf4j
@Api(tags="取值函数配置")
@ApiGroup(group = {ApiGroupConsts.GROUP_APPLICATION})
@RequestMapping("/components/componentFunction")
@RestController
public class ComponentFunctionController extends BaseController<ComponentFunctionManager, ComponentFunctionEntity> {

    @Resource
    ComponentFunctionManager componentFunctionService;



    @ApiOperation("新增取值函数信息")
    @PostMapping("/insertComponentFunction")
    public CommonResult<String> insertComponentFunction(@RequestBody ComponentFunctionEntity componentFunctionEntity){
        try {
            this.componentFunctionService.insertComponentFunction(componentFunctionEntity);
            return new CommonResult<String>(true, componentFunctionEntity.getId());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return new CommonResult<String>(false, "新增出错"+e.getMessage());
        }
    }

    @ApiOperation("修改取值函数信息")
    @PostMapping("/updateComponentFunction")
//    @RequiresPermissions("componentFunction:update")
    public CommonResult<String> updateComponentFunction(@RequestBody ComponentFunctionEntity componentFunctionEntity){
        try {
            this.componentFunctionService.updateComponentFunction(componentFunctionEntity);
            return new CommonResult<String>(true, componentFunctionEntity.getId());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return new CommonResult<String>(false, "出错"+e.getMessage());
        }
    }

    @ApiOperation("根据ID查询取值函数信息")
    @PostMapping("/loadComponentFunction")
    public ComponentFunctionEntity loadComponentFunction(@ApiParam("取值函数ID") @RequestParam String id){
        return this.componentFunctionService.loadComponentFunction(id);
    }

    @ApiOperation("根据ID批量删除取值函数信息")
    @PostMapping("/deleteComponentFunction")
    public CommonResult<String> deleteComponentFunction(@ApiParam("取值函数ID集合，用逗号隔开") @RequestParam String ids){
        try {
            this.componentFunctionService.deleteComponentFunction(ids);
            return new CommonResult<String>();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return new CommonResult<String>(false, "出错"+e.getMessage());
        }
    }

    @RequestMapping(value = "listJson", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "取值函数列表(分页条件查询)数据", httpMethod = "POST", notes = "取值函数列表(分页条件查询)数据")
    public @ResponseBody PageList<ComponentFunctionEntity> listJson(@ApiParam(name = "queryFilter", value = "通用查询对象") @RequestBody QueryFilter<ComponentFunctionEntity> queryFilter) throws Exception {
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("ID_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return componentFunctionService.query(queryFilter);
    }


}
