package com.artfess.cqxy.search.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.api.ApiController;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

/**
 * 档案全局检索表(BizGlobalRetrieval)表控制层
 *
 * @author 黎沐华
 * @since 2022-03-22 13:13:32
 */
@Slf4j
@RestController
@Api(tags = "档案全局检索接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RequestMapping("/biz/globalRetrieval/v1")
public class GlobalRetrievalController extends BaseController<GlobalRetrievalManager, GlobalRetrieval> {

    /**
     * 保存或修改数据
     * @param progressManage 实体对象
     * @return 新增或更新结果
     */
    @PostMapping("/save")
    @ApiOperation(value = "S-保存或修改数据",httpMethod = "POST")
    public CommonResult<String> insert(@RequestBody GlobalRetrieval progressManage) {
        log.debug("档案全局检索-保存或修改数据接口请求参数：{}", progressManage);
        boolean add = StringUtils.isEmpty(progressManage.getId());
        boolean save = baseService.saveOrUpdate(progressManage);
        String msg = (add ? "添加" : "修改")+(save ? "成功" : "失败");
        log.debug("档案全局检索-保存或修改数据接口响应结果：{}", msg);
        return new CommonResult<>(save, msg);
    }
    
    /**
     * 删除数据
     * @param ids 主键集合
     * @return 删除结果
     */
    @PostMapping("/delete")
    @ApiOperation(value = "S-删除数据",httpMethod = "POST")
    public CommonResult delete(@ApiParam(name = "ids",value = "ID集合") @RequestParam("ids") String ids) {
        log.debug("档案全局检索-删除数据接口请求参数：{}", ids);
        Assert.notNull(ids,"主键集合不能为空");
        boolean state = baseService.removeByIds(Arrays.asList(ids.split(",")));
        String msg = state ? "删除成功" : "删除失败";
        log.debug("档案全局检索-删除数据接口响应结果：{}", msg);
        return new CommonResult<String>(state, msg);
    }

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询所有数据",httpMethod = "POST")
    public CommonResult<PageList<GlobalRetrieval>> selectAll(@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<GlobalRetrieval> queryFilter) {
        log.debug("档案全局检索-分页查询所有数据接口请求参数：{}", queryFilter);
        PageList<GlobalRetrieval> result = baseService.queryAllByPage(queryFilter);
        log.debug("档案全局检索-分页查询所有数据接口响应结果：{}", result);
        return new CommonResult<>(true,"操作成功",result);
    }

}
