package com.artfess.cqxy.projectManagement.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.projectManagement.manager.ProjectPersonnelManager;
import com.artfess.cqxy.projectManagement.model.DirectoryManagement;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.api.ApiController;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.artfess.cqxy.projectManagement.model.DirectoryManagement;
import com.artfess.cqxy.projectManagement.manager.DirectoryManagementManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * 目录管理表(BizDirectoryManagement)表控制层
 * @author 黎沐华
 * @since 2022-02-16 09:04:11
 */
@Slf4j
@RestController
@Api(tags = "项目管理-目录管理接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RequestMapping("/biz/projectManagement/directoryManagement/v1")
public class DirectoryManagementController extends BaseController<DirectoryManagementManager, DirectoryManagement> {

    /**
     * 保存或修改数据
     * @param dirObject 实体对象
     * @return 新增结果
     */
    @PostMapping("/save")
    @ApiOperation(value = "S-保存或修改数据",httpMethod = "POST")
    public CommonResult save(@ApiParam(name = "dirObject", value = "目录管理信息表对象") @RequestBody DirectoryManagement dirObject) {
        log.debug("目录管理-保存或修改数据接口请求参数：{}", dirObject);
        Assert.notNull(dirObject,"新增数据不能为空");
        boolean add = StringUtils.isEmpty(dirObject.getId());
        boolean save = add ? baseService.save(dirObject) : baseService.updateById(dirObject);
        // 新增时添加到父节点，要改变父节点的hasChildren状态
        baseService.changeHasChildNode(dirObject,true);
        String msg = (add ? "添加" : "修改")+(save ? "成功" : "失败");
        log.debug("目录管理-保存或修改数据接口响应结果：{}", msg);
        return new CommonResult(save,msg);
    }

    /**
     * 删除数据
     * @param ids 主键集合
     * @return 删除结果
     */
    @PostMapping("/delete")
    @ApiOperation(value = "S-删除数据",httpMethod = "POST")
    public CommonResult delete(@ApiParam(name = "ids",value = "ID集合") @RequestParam("ids") String ids) {
        log.debug("目录管理-删除数据接口请求参数：{}", ids);
        Assert.notNull(ids,"主键集合不能为空");
        boolean state = baseService.removeByIds(Arrays.asList(ids.split(",")));
        String msg = state ? "删除成功" : "删除失败";
        log.debug("目录管理-删除数据接口响应结果：{}", msg);
        return new CommonResult(state, msg);
    }

    /**
     * 修改项目排序号
     * @param params params
     * @return msg
     */
    @PostMapping("/updateSequence")
    @ApiOperation(value = "S-修改项目排序号",notes = "前端拖动记录进行排序，那么要传入发生变动的记录的ID及排序号，如\"params\":{\"ID值\":\"排序号\",\"ID值\":\"排序号\"}",httpMethod = "POST")
    public CommonResult sort(@ApiParam(name = "params", value = "参数说明：Key：ID，Value：排序号") @RequestBody HashMap<String, Integer> params){
        log.debug("目录管理-修改项目排序号接口请求参数：{}",params);
        baseService.updateSequence(params);
        return new CommonResult(true, "操作成功");
    }

    /**
     * 通过主键查询单条数据
     * @param id 主键
     * @return 单条数据
     */
    @PostMapping("/detail/{id}")
    @ApiOperation(value = "S-根据ID查询详情",httpMethod = "POST")
    public CommonResult<DirectoryManagement> selectOne(@ApiParam(name = "id",value = "主键ID") @PathVariable String id) {
        log.debug("目录管理-根据ID查询详情 接口请求参数：{}", id);
        Assert.notNull(id,"主键不能为空");
        DirectoryManagement result = baseService.getById(id);
        boolean state = !BeanUtils.isEmpty(result);
        log.debug("目录管理-根据ID查询详情 接口响应结果：{}", result);
        return new CommonResult<DirectoryManagement>(state, state?"操作成功":"该ID没有对应数据", result);
    }


    @PostMapping("/getByParentId")
    @ApiOperation(value = "S-根据父节点编码查询其子节点",notes = "根据父节点编码查询子节点，URL传参pCode，根节点为root",httpMethod = "POST")
    public CommonResult<List<DirectoryManagement>> getByParentId(@RequestParam String pCode) {
        log.debug("目录管理-获取树状数据接口请求参数：{}",pCode);
        List<DirectoryManagement> result = baseService.getByParentId(pCode);
        log.debug("目录管理-获取树状数据接口响应结果：{}", result);
        return new CommonResult<List<DirectoryManagement>>(true,"操作成功",result);
    }

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 分页数据
     */
    @PostMapping("/queryChildNodeByPage")
    @ApiOperation(value = "S-分页查询所有数据",notes = "参数说明：在通用查询器中的query对象组传入查询参数，必须传入 PCODE_ 父节点名，所有参数都需要带上表别名——bdm",httpMethod = "POST")
    public CommonResult<PageList<DirectoryManagement>> queryChildNodeByPage(@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<DirectoryManagement> queryFilter) {
        log.debug("目录管理-分页查询所有数据接口请求参数：{}", queryFilter);
        PageList<DirectoryManagement> result = baseService.queryChildNodeByPage(queryFilter);
        log.debug("目录管理-分页查询所有数据接口响应结果：{}", result);
        return new CommonResult<PageList<DirectoryManagement>>(true,"操作成功",result);
    }

}

