package com.artfess.workflow.runtime.job;

import javax.annotation.Resource;

import org.springframework.stereotype.Component;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.artfess.base.constants.SystemConstants;
import com.artfess.base.exception.BaseException;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.workflow.runtime.controller.InstanceController;
import com.artfess.workflow.runtime.params.StartFlowParamObject;
import com.artfess.workflow.runtime.params.StartResult;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;

/**
 * 定时启动流程
 *
 * @company 广州宏天软件股份有限公司
 * @author jason
 * @email liygui@jee-soft.cn
 * @date 2020年5月28日
 */
@Component
public class FlowStartXxlJob {
	@Resource
	InstanceController instanceController;

	/**
     * 1、简单任务示例（Bean模式）
     */
    @XxlJob("flowStartXxlJob")
    public ReturnT<String> flowStartXxlJob(String param) throws Exception {
    	 XxlJobLogger.log("XXL-JOB, 开始执行定时启动流程.");
		String defaultAccount = SystemConstants.SYSTEM_ACCOUNT;
		JsonNode jsonNode = JsonUtil.toJsonNode(param);
		String flowkey = jsonNode.get("flowkey").asText();
		String startAccount = jsonNode.get("startAccount").asText();
		if(StringUtil.isNotEmpty(startAccount)) {
			defaultAccount = startAccount;
		}
		// 定时任务中没有当前登录用户，所以需要设置到当前用户上下文中
		ContextUtil.setCurrentUserByAccount(defaultAccount);
		if(BeanUtils.isEmpty(flowkey)) {
			throw new BaseException("定时启动流程的自动任务中必须配置flowkey来指定要启动的流程.");
		}
		startFlow(flowkey, defaultAccount);
		return ReturnT.SUCCESS;
	}
	
	private void startFlow(String flowKey, String account) throws Exception {
		// 构建启动流程的参数
		ObjectNode startFlowParam = JsonUtil.getMapper().createObjectNode();
		startFlowParam.put("flowKey", flowKey);
		startFlowParam.put("account", account);
		StartFlowParamObject startFlowParamObject = new StartFlowParamObject();
		startFlowParamObject.setFlowKey(flowKey);
		startFlowParamObject.setAccount(account);
		// 调用接口启动流程
		StartResult startFlowResult = instanceController.start(startFlowParamObject);
	
		if(BeanUtils.isNotEmpty(startFlowResult) && !startFlowResult.getState()) {
			String message = "流程启动失败";
			if(BeanUtils.isNotEmpty(startFlowResult) && BeanUtils.isNotEmpty(startFlowResult.getMessage())) {
				message += ":" + startFlowResult.getMessage();
			}
			throw new BaseException(message);
		}
	}
}
