package com.artfess.cqxy.projectManagement.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author Limuhua
 * @date 2022/2/24 16:52
 */
public enum ProjectStatusEnum {
//1：决策，2：立项：3：可研，4：规划，5：初设，6：概算，7：施工图，8：招投标，9：合同，10：施工许可，11：工程施工，12：竣工验收，13：结算，14：决算，15：移交
    one("1", "决策"),

    two("2", "立项"),

    three("3", "可研"),

    four("4", "规划"),

    five("5", "初设"),

    six("6", "概算"),

    seven("7", "施工图"),

    eight("8", "招投标"),

    nine("9", "合同"),

    ten("10", "施工许可"),

    eleven("11", "工程施工"),

    twelve("12", "竣工验收"),

    thirteen("13", "结算"),

    forteen("14", "决算"),

    fivteen("15", "移交")
    ;

    ProjectStatusEnum(String code, String value) {
        this.code = code;
        this.value = value;
    }

    private String code;
    private String value;

    public String getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }

    public static String getValue(String code){
        if(StringUtils.isEmpty(code)){
            return null;
        }
        ProjectStatusEnum[] values = values();
        for (ProjectStatusEnum state : values) {
            if (state.getCode().equals(code)) {
                return state.getValue();
            }
        }
        return null;
    }
}
